/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ToDoStatus;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ToDoProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String description = null;
    private Date creationTime = null;
    private int priority = 0;
    private Date dueTime = null;
    private Date completionTime = null;
    private ToDoStatus status = null;

    public ToDoProperties() {
    }

    public ToDoProperties(ToDoProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.description = template.getDescription();
            this.creationTime = template.getCreationTime();
            this.priority = template.getPriority();
            this.dueTime = template.getDueTime();
            this.completionTime = template.getCompletionTime();
            this.status = template.getStatus();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Date getDueTime() {
        return this.dueTime;
    }

    public void setDueTime(Date dueTime) {
        this.dueTime = dueTime;
    }

    public Date getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }

    public ToDoStatus getStatus() {
        return this.status;
    }

    public void setStatus(ToDoStatus status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "ToDoProperties{name='" + this.name + "', description='" + this.description + "', creationTime=" + this.creationTime + ", priority=" + this.priority + ", dueTime=" + this.dueTime + ", completionTime=" + this.completionTime + ", status=" + this.status + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ToDoProperties that = (ToDoProperties)objectToCompare;
        return this.priority == that.priority && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.dueTime, that.dueTime) && Objects.equals(this.completionTime, that.completionTime) && this.status == that.status;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getDescription(), this.getCreationTime(), this.getPriority(), this.getDueTime(), this.getCompletionTime(), this.getStatus(), this.getExtendedProperties(), this.getAdditionalProperties());
    }
}

