/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetProperties
extends ReferenceableProperties {
    private String name = null;
    private String versionIdentifier = null;
    private String description = null;
    private Date dateAssetCreated = null;
    private Date dateAssetLastUpdated = null;

    public AssetProperties() {
    }

    public AssetProperties(AssetProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.versionIdentifier = template.getVersionIdentifier();
            this.description = template.getDescription();
            this.dateAssetCreated = template.getDateAssetCreated();
            this.dateAssetLastUpdated = template.getDateAssetLastUpdated();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDateAssetCreated() {
        if (this.dateAssetCreated == null) {
            return null;
        }
        return new Date(this.dateAssetCreated.getTime());
    }

    public void setDateAssetCreated(Date dateAssetCreated) {
        this.dateAssetCreated = dateAssetCreated;
    }

    public Date getDateAssetLastUpdated() {
        if (this.dateAssetLastUpdated == null) {
            return null;
        }
        return new Date(this.dateAssetLastUpdated.getTime());
    }

    public void setDateAssetLastUpdated(Date dateAssetLastUpdated) {
        this.dateAssetLastUpdated = dateAssetLastUpdated;
    }

    @Override
    public String toString() {
        return "AssetProperties{name='" + this.name + "', versionIdentifier='" + this.versionIdentifier + "', description='" + this.description + "', dateAssetCreated=" + this.dateAssetCreated + ", dateAssetLastUpdated=" + this.dateAssetLastUpdated + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetProperties that = (AssetProperties)objectToCompare;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.versionIdentifier != null ? !this.versionIdentifier.equals(that.versionIdentifier) : that.versionIdentifier != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.dateAssetCreated != null ? !this.dateAssetCreated.equals(that.dateAssetCreated) : that.dateAssetCreated != null) {
            return false;
        }
        return this.dateAssetLastUpdated != null ? this.dateAssetLastUpdated.equals(that.dateAssetLastUpdated) : that.dateAssetLastUpdated == null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getVersionIdentifier(), this.getDescription(), this.getDateAssetCreated(), this.getDateAssetLastUpdated(), this.getExtendedProperties(), this.getAdditionalProperties());
    }
}

