/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class NoteLogEntryProperties
extends ReferenceableProperties {
    private List<String> contributors = null;
    private String title = null;
    private String text = null;

    public NoteLogEntryProperties() {
    }

    public NoteLogEntryProperties(NoteLogEntryProperties template) {
        super(template);
        if (template != null) {
            this.contributors = template.getContributors();
            this.title = template.getTitle();
            this.text = template.getText();
        }
    }

    public List<String> getContributors() {
        if (this.contributors == null) {
            return null;
        }
        if (this.contributors.isEmpty()) {
            return null;
        }
        return this.contributors;
    }

    public void setContributors(List<String> contributors) {
        this.contributors = contributors;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return "NoteLogEntryProperties{contributors=" + this.contributors + ", title='" + this.title + "', text='" + this.text + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        NoteLogEntryProperties that = (NoteLogEntryProperties)objectToCompare;
        return Objects.equals(this.getContributors(), that.getContributors()) && Objects.equals(this.getTitle(), that.getTitle()) && Objects.equals(this.getText(), that.getText());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getContributors(), this.getTitle(), this.getText());
    }
}

