/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum CommunityProfileAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-COMMUNITY-PROFILE-0001", AuditLogRecordSeverityLevel.STARTUP, "The Community Profile Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Community Profile OMAS.  This service supports the personal profiles used in the user interface.  It also manages organization,departmental and community information and will reward individual contribution to open metadata as karma points.  It can receive a feed of the latest user, organizational and profile information through a feed from another system and will publish significant events such as whenever an individual reaches a karma point plateau.", "No action is required if this service is required."),
    SERVICE_PUBLISHING("OMAS-COMMUNITY-PROFILE-0002", AuditLogRecordSeverityLevel.STARTUP, "The Community Profile Open Metadata Access Service (OMAS) is ready to publish data manager notifications to topic {0}", "The local server has started up the event publisher for the Community Profile OMAS.  It will begin publishing data manager metadata changes to its out topic.", "This is part of the normal start up of the service. Check that there are no errors from the event bus."),
    SERVICE_INSTANCE_FAILURE("OMAS-COMMUNITY-PROFILE-0003", AuditLogRecordSeverityLevel.EXCEPTION, "The Community Profile Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The Community Profile OMAS detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_INITIALIZED("OMAS-COMMUNITY-PROFILE-0004", AuditLogRecordSeverityLevel.STARTUP, "The Community Profile Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that he service started successfully.  You should see the start up of both the in topic and out topic as well as information about the karma point threshold that is in operation."),
    SERVICE_SHUTDOWN("OMAS-COMMUNITY-PROFILE-0005", AuditLogRecordSeverityLevel.SHUTDOWN, "The Community Profile Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local server has requested shut down of an Community Profile OMAS instance.", "No action is required if shutdown was requested."),
    PUBLISHING_SHUTDOWN("OMAS-COMMUNITY-PROFILE-0006", AuditLogRecordSeverityLevel.SHUTDOWN, "The Community Profile Open Metadata Access Service (OMAS) is no longer publishing events to topic {0}", "The local administrator has requested shut down of an Community Profile OMAS instance.  No more events will be published to the named topic.", "This is part of the normal shutdown of the service.   No action is required if this is serviceshutdown was intentional."),
    PUBLISHING_SHUTDOWN_ERROR("OMAS-COMMUNITY-PROFILE-0007", AuditLogRecordSeverityLevel.SHUTDOWN, "The Community Profile Open Metadata Access Service (OMAS) caught an unexpected {0} exception whilst shutting down the out topic {1}. The error message was: {2}", "The local administrator has requested shut down of an Community Profile OMAS instance.  No more events will be published to the named topic, although the connection to the event bus may not be released properly.", "This is part of the normal shutdown of the service. However, an exception is not expected at this point unless it is the consequence of a previous error. Review the error message and any other reported failures to determine if this exception needs special attention."),
    OUTBOUND_EVENT_EXCEPTION("OMAS-COMMUNITY-PROFILE-0013", AuditLogRecordSeverityLevel.EXCEPTION, "Unable to send an outbound event of type {0} for instance with unique identifier of {1} and type name {2} due to exception {3}.  The error message from the exception was {4}", "The system detected an exception whilst attempting to send an event to the out topic.  No event is sent.", "Investigate and correct the source of the error.  Once fixed, events will be sent."),
    KARMA_PLATEAU_AWARD("OMAS-COMMUNITY-PROFILE-0100", AuditLogRecordSeverityLevel.INFO, "{0} has reached a new karma point plateau of {1} with {2} karma points", "The Community Profile OMAS has detected a contribution by an individual that takes them to the next plateau.", "This information is also sent on the out topic and could result in additional recognition for the individual."),
    KARMA_POINT_EXCEPTION("OMAS-COMMUNITY-PROFILE-0101", AuditLogRecordSeverityLevel.EXCEPTION, "Unable to award karma points to {0} due to exception {1}.  The error message from the exception was {2}", "The system detected an exception whilst attempting to award karma points.  No karma points were awarded.", "Investigate and correct the source of the error.  Once fixed, karma points will be awarded for new activity."),
    OUT_TOPIC_EVENT("OMAS-COMMUNITY-PROFILE-0200", AuditLogRecordSeverityLevel.EVENT, "The Community Profile Open Metadata Access Service (OMAS) has sent event of type: {0}", "The access service sends out notifications about changes to relevant elements.  This message is to create a record of the events that are being published.", "This event indicates that one of the elements has changed.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private CommunityProfileAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "CommunityProfileAuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

