/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.MyPersonalProfileInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.InvalidParameterHandler;
import org.odpi.openmetadata.accessservices.communityprofile.client.RESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.RESTExceptionHandler;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.communityprofile.properties.AssetCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethod;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodType;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.communityprofile.rest.CommunityProfileOMASAPIResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.CountResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MyProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.NullRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.VoidResponse;

public class MyProfileManagement
implements MyPersonalProfileInterface {
    private String serverName;
    private String omasServerURL;
    private RESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public MyProfileManagement(String serverName, String omasServerURL) {
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new RESTClient(serverName, omasServerURL);
    }

    public MyProfileManagement(String serverName, String omasServerURL, String userId, String password) {
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new RESTClient(serverName, omasServerURL, userId, password);
    }

    public PersonalProfile getMyProfile(String userId) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMyProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getMyProfile");
        this.invalidParameterHandler.validateUserId(userId, "getMyProfile");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getMyProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile", userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getMyProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowNoProfileForUserException("getMyProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getMyProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getMyProfile", (CommunityProfileOMASAPIResponse)restResult);
        return restResult.getPersonalProfile();
    }

    public int getMyKarmaPoints(String userId) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMyKarmaPoints";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/karma-points";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getMyKarmaPoints");
        this.invalidParameterHandler.validateUserId(userId, "getMyKarmaPoints");
        CountResponse restResult = this.restClient.callCountGetRESTCall("getMyKarmaPoints", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/karma-points", userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getMyKarmaPoints", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowNoProfileForUserException("getMyKarmaPoints", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getMyKarmaPoints", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getMyKarmaPoints", (CommunityProfileOMASAPIResponse)restResult);
        return restResult.getCount();
    }

    public void setUpMyProfile(String userId, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> profileProperties, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateMyProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile";
        String qualifiedNameParameterName = "qualifiedName";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "updateMyProfile");
        this.invalidParameterHandler.validateUserId(userId, "updateMyProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateMyProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "updateMyProfile");
        MyProfileRequestBody requestBody = new MyProfileRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateMyProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile", requestBody, this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateMyProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateMyProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateMyProfile", (CommunityProfileOMASAPIResponse)restResult);
    }

    public void deleteMyProfile(String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteMyProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/delete";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "deleteMyProfile");
        this.invalidParameterHandler.validateUserId(userId, "deleteMyProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteMyProfile");
        PersonalProfileValidatorRequestBody requestBody = new PersonalProfileValidatorRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteMyProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/delete", requestBody, this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("deleteMyProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deleteMyProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deleteMyProfile", (CommunityProfileOMASAPIResponse)restResult);
    }

    public List<ContactMethod> getMyContactDetails(String UserId) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void setUpMyProfile(String userId, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, List<ContactMethod> contactDetails, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    public String addContactMethod(String userId, ContactMethodType type, String service, String value) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void deleteContactMethod(String userId, String contactMethodGUID, ContactMethodType type) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
    }

    public List<AssetCollectionMember> getMyAssets(String userId, int startFrom, int pageSize) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void addToMyAssets(String userId, String assetGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
    }

    public void removeFromMyAssets(String userId, String assetGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
    }
}

