/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.PersonalProfileManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.InvalidParameterHandler;
import org.odpi.openmetadata.accessservices.communityprofile.client.RESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.RESTExceptionHandler;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.communityprofile.rest.CommunityProfileOMASAPIResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.VoidResponse;

public class PersonalProfileManagement
implements PersonalProfileManagementInterface {
    private String serverName;
    private String omasServerURL;
    private RESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public PersonalProfileManagement(String serverName, String omasServerURL) {
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new RESTClient(serverName, omasServerURL);
    }

    public PersonalProfileManagement(String serverName, String omasServerURL, String userId, String password) {
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new RESTClient(serverName, omasServerURL, userId, password);
    }

    public String createPersonalProfile(String userId, String profileUserId, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> profileProperties, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles";
        String profileUserIdParameterName = "profileUserId";
        String qualifiedParameterName = "qualifiedName";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "createPersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "createPersonalProfile");
        this.invalidParameterHandler.validateName(profileUserId, "profileUserId", "createPersonalProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createPersonalProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "createPersonalProfile");
        PersonalProfileRequestBody requestBody = new PersonalProfileRequestBody();
        requestBody.setUserId(profileUserId);
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setProfileProperties(profileProperties);
        requestBody.setAdditionalProperties(additionalProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPersonalProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles", requestBody, this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("createPersonalProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createPersonalProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createPersonalProfile", (CommunityProfileOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    public void updatePersonalProfile(String userId, String profileGUID, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> profileProperties, Map<String, String> additionalProperties) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updatePersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}";
        String guidParameterName = "profileGUID";
        String qualifiedNameParameterName = "qualifiedName";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "updatePersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "updatePersonalProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "updatePersonalProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updatePersonalProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "updatePersonalProfile");
        PersonalProfileRequestBody requestBody = new PersonalProfileRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setProfileProperties(profileProperties);
        requestBody.setAdditionalProperties(additionalProperties);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updatePersonalProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}", requestBody, this.serverName, userId, profileGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("updatePersonalProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updatePersonalProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updatePersonalProfile", (CommunityProfileOMASAPIResponse)restResult);
    }

    public void deletePersonalProfile(String userId, String profileGUID, String qualifiedName) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deletePersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}/delete";
        String guidParameterName = "profileGUID";
        String employeeNumberParameterName = "employeeNumber";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "deletePersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "deletePersonalProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "deletePersonalProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "employeeNumber", "deletePersonalProfile");
        PersonalProfileValidatorRequestBody requestBody = new PersonalProfileValidatorRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deletePersonalProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}/delete", requestBody, this.serverName, userId, profileGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("deletePersonalProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deletePersonalProfile", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deletePersonalProfile", (CommunityProfileOMASAPIResponse)restResult);
    }

    public PersonalProfile getPersonalProfileByGUID(String userId, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}";
        String guidParameterName = "profileGUID";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getPersonalProfileByGUID");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileByGUID");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "getPersonalProfileByGUID");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileByGUID", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}", this.serverName, userId, profileGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getPersonalProfileByGUID", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfileByGUID", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfileByGUID", (CommunityProfileOMASAPIResponse)restResult);
        return restResult.getPersonalProfile();
    }

    public PersonalProfile getPersonalProfileForUser(String userId, String profileUserId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileForUser";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-user/{2}";
        String profileUserIdParameterName = "profileUserId";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getPersonalProfileForUser");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileForUser");
        this.invalidParameterHandler.validateName(profileUserId, "profileUserId", "getPersonalProfileForUser");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileForUser", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-user/{2}", this.serverName, userId, profileUserId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getPersonalProfileForUser", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfileForUser", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfileForUser", (CommunityProfileOMASAPIResponse)restResult);
        return restResult.getPersonalProfile();
    }

    public PersonalProfile getPersonalProfileByQualifiedName(String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByQualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-qualified-name/{2}";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getPersonalProfileByQualifiedName");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileByQualifiedName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getPersonalProfileByQualifiedName");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileByQualifiedName", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-qualified-name/{2}", this.serverName, userId, qualifiedName);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getPersonalProfileByQualifiedName", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfileByQualifiedName", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfileByQualifiedName", (CommunityProfileOMASAPIResponse)restResult);
        return restResult.getPersonalProfile();
    }

    public List<PersonalProfile> getPersonalProfilesByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfilesByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-name/{2}";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getPersonalProfilesByName");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfilesByName");
        this.invalidParameterHandler.validateName(name, "name", "getPersonalProfilesByName");
        PersonalProfileListResponse restResult = this.restClient.callPersonalProfileListGetRESTCall("getPersonalProfilesByName", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-name/{2}", this.serverName, userId, name);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getPersonalProfilesByName", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfilesByName", (CommunityProfileOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfilesByName", (CommunityProfileOMASAPIResponse)restResult);
        return restResult.getPersonalProfiles();
    }
}

