/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.communityprofile.rest.AssetListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.CountResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.VoidResponse;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;

class RESTClient {
    private RestTemplate restTemplate;
    private String serverName;
    private String omasServerURL;

    RESTClient(String serverName, String omasServerURL) {
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restTemplate = new RestTemplate();
    }

    RESTClient(String serverName, String omasServerURL, String userId, String password) {
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        this.restTemplate = restTemplateBuilder.basicAuthentication(userId, password).build();
    }

    PersonalProfileResponse callPersonalProfileGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (PersonalProfileResponse)this.callGetRESTCall(methodName, PersonalProfileResponse.class, urlTemplate, params);
    }

    PersonalProfileListResponse callPersonalProfileListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (PersonalProfileListResponse)this.callGetRESTCall(methodName, PersonalProfileListResponse.class, urlTemplate, params);
    }

    CountResponse callCountGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (CountResponse)this.callGetRESTCall(methodName, CountResponse.class, urlTemplate, params);
    }

    GUIDResponse callGUIDGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (GUIDResponse)this.callGetRESTCall(methodName, GUIDResponse.class, urlTemplate, params);
    }

    AssetListResponse callAssetListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (AssetListResponse)this.callGetRESTCall(methodName, AssetListResponse.class, urlTemplate, params);
    }

    GUIDResponse callGUIDPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        return (GUIDResponse)this.callPostRESTCall(methodName, GUIDResponse.class, urlTemplate, requestBody, params);
    }

    VoidResponse callVoidPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        return (VoidResponse)this.callPostRESTCall(methodName, VoidResponse.class, urlTemplate, requestBody, params);
    }

    private Object callGetRESTCall(String methodName, Class returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return this.restTemplate.getForObject(urlTemplate, returnClass, params);
        }
        catch (Throwable error) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.omasServerURL, error.getMessage()});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private Object callPostRESTCall(String methodName, Class returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, params);
        }
        catch (Throwable error) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.serverName, this.omasServerURL, error.getMessage()});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }
}

