/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.communityprofile.rest.CommunityProfileOMASAPIResponse;

class RESTExceptionHandler {
    RESTExceptionHandler() {
    }

    void detectAndThrowInvalidParameterException(String methodName, CommunityProfileOMASAPIResponse restResult) throws InvalidParameterException {
        String exceptionClassName = InvalidParameterException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String paramName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
                paramName = (String)nameObject;
            }
            throw new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), paramName);
        }
    }

    void detectAndThrowPropertyServerException(String methodName, CommunityProfileOMASAPIResponse restResult) throws PropertyServerException {
        String exceptionClassName = PropertyServerException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new PropertyServerException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }

    void detectAndThrowNoProfileForUserException(String methodName, CommunityProfileOMASAPIResponse restResult) throws NoProfileForUserException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object userIdObject;
            String userId = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (userIdObject = exceptionProperties.get("userId")) != null) {
                userId = (String)userIdObject;
            }
            throw new NoProfileForUserException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), userId);
        }
    }

    void detectAndThrowUserNotAuthorizedException(String methodName, CommunityProfileOMASAPIResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object userIdObject;
            String userId = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (userIdObject = exceptionProperties.get("userId")) != null) {
                userId = (String)userIdObject;
            }
            throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), userId);
        }
    }
}

