/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.api.MyPersonalProfileInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.RESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.RESTExceptionHandler;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.communityprofile.properties.AssetCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethod;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodType;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MyProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.CountResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class MyProfileManagement
implements MyPersonalProfileInterface {
    private String serverName;
    private String omasServerURL;
    private RESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public MyProfileManagement(String serverName, String omasServerURL) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new RESTClient(serverName, omasServerURL);
    }

    public MyProfileManagement(String serverName, String omasServerURL, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new RESTClient(serverName, omasServerURL, userId, password);
    }

    public PersonalProfile getMyProfile(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMyProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getMyProfile");
        this.invalidParameterHandler.validateUserId(userId, "getMyProfile");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getMyProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile", userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getMyProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getMyProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getMyProfile", (FFDCResponseBase)restResult);
        return restResult.getPersonalProfile();
    }

    public long getMyKarmaPoints(String userId) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMyKarmaPoints";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/karma-points";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getMyKarmaPoints");
        this.invalidParameterHandler.validateUserId(userId, "getMyKarmaPoints");
        CountResponse restResult = this.restClient.callCountGetRESTCall("getMyKarmaPoints", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/karma-points", new Object[]{userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getMyKarmaPoints", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowNoProfileForUserException("getMyKarmaPoints", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getMyKarmaPoints", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getMyKarmaPoints", (FFDCResponseBase)restResult);
        return restResult.getCount();
    }

    public void setUpMyProfile(String userId, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "setUpMyProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile";
        String qualifiedNameParameterName = "qualifiedName";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "setUpMyProfile");
        this.invalidParameterHandler.validateUserId(userId, "setUpMyProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "setUpMyProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "setUpMyProfile");
        MyProfileRequestBody requestBody = new MyProfileRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("setUpMyProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("setUpMyProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("setUpMyProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("setUpMyProfile", (FFDCResponseBase)restResult);
    }

    public void deleteMyProfile(String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteMyProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/delete";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "deleteMyProfile");
        this.invalidParameterHandler.validateUserId(userId, "deleteMyProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteMyProfile");
        PersonalProfileValidatorRequestBody requestBody = new PersonalProfileValidatorRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteMyProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/delete", requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException("deleteMyProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deleteMyProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deleteMyProfile", (FFDCResponseBase)restResult);
    }

    public List<ContactMethod> getMyContactDetails(String UserId) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void setUpMyProfile(String userId, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, List<ContactMethod> contactDetails, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    public String addMyContactMethod(String userId, ContactMethodType type, String service, String value) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void deleteMyContactMethod(String userId, String contactMethodGUID, ContactMethodType type) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
    }

    public List<AssetCollectionMember> getMyAssets(String userId, int startFrom, int pageSize) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void addToMyAssets(String userId, String assetGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
    }

    public void removeFromMyAssets(String userId, String assetGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
    }
}

