/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileRESTExceptionHandler;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.communityprofile.rest.AssetListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CountResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClientBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

class CommunityProfileRESTClient
extends FFDCRESTClientBase {
    private CommunityProfileRESTExceptionHandler localRESTExceptionHandler = new CommunityProfileRESTExceptionHandler();

    CommunityProfileRESTClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    CommunityProfileRESTClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    VoidResponse callVoidPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws InvalidParameterException, NoProfileForUserException, UserNotAuthorizedException, PropertyServerException {
        VoidResponse restResult = (VoidResponse)this.callPostRESTCall(methodName, VoidResponse.class, urlTemplate, requestBody, params);
        this.localRESTExceptionHandler.detectAndThrowNoProfileForUserException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponseBase)restResult);
        return restResult;
    }

    public GUIDResponse callGUIDPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        GUIDResponse restResult = (GUIDResponse)this.callPostRESTCall(methodName, GUIDResponse.class, urlTemplate, requestBody, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponseBase)restResult);
        return restResult;
    }

    public CountResponse callCountGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        CountResponse restResult = (CountResponse)this.callGetRESTCall(methodName, CountResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponseBase)restResult);
        return restResult;
    }

    PersonalProfileResponse callPersonalProfileGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonalProfileResponse restResult = (PersonalProfileResponse)this.callGetRESTCall(methodName, PersonalProfileResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponseBase)restResult);
        return restResult;
    }

    PersonalProfileListResponse callPersonalProfileListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonalProfileListResponse restResult = (PersonalProfileListResponse)this.callGetRESTCall(methodName, PersonalProfileListResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponseBase)restResult);
        return restResult;
    }

    AssetListResponse callAssetListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AssetListResponse restResult = (AssetListResponse)this.callGetRESTCall(methodName, AssetListResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponseBase)restResult);
        return restResult;
    }
}

