/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.api.PersonalProfileManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileRESTExceptionHandler;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethod;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodType;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class PersonalProfileManagement
implements PersonalProfileManagementInterface {
    private String serverName;
    private String omasServerURL;
    private CommunityProfileRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private CommunityProfileRESTExceptionHandler exceptionHandler = new CommunityProfileRESTExceptionHandler();

    public PersonalProfileManagement(String serverName, String omasServerURL) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new CommunityProfileRESTClient(serverName, omasServerURL);
    }

    public PersonalProfileManagement(String serverName, String omasServerURL, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new CommunityProfileRESTClient(serverName, omasServerURL, userId, password);
    }

    public String createPersonalProfile(String userId, String profileUserId, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles";
        String profileUserIdParameterName = "profileUserId";
        String qualifiedParameterName = "qualifiedName";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "createPersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "createPersonalProfile");
        this.invalidParameterHandler.validateName(profileUserId, "profileUserId", "createPersonalProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createPersonalProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "createPersonalProfile");
        PersonalProfileRequestBody requestBody = new PersonalProfileRequestBody();
        requestBody.setProfileUserId(profileUserId);
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPersonalProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles", requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    public void updatePersonalProfile(String userId, String profileGUID, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> profileProperties, Map<String, String> additionalProperties) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updatePersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}";
        String guidParameterName = "profileGUID";
        String qualifiedNameParameterName = "qualifiedName";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "updatePersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "updatePersonalProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "updatePersonalProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updatePersonalProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "updatePersonalProfile");
        PersonalProfileRequestBody requestBody = new PersonalProfileRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setProfileProperties(profileProperties);
        requestBody.setAdditionalProperties(additionalProperties);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updatePersonalProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}", requestBody, this.serverName, userId, profileGUID);
    }

    public void deletePersonalProfile(String userId, String profileGUID, String qualifiedName) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deletePersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}/delete";
        String guidParameterName = "profileGUID";
        String employeeNumberParameterName = "employeeNumber";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "deletePersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "deletePersonalProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "deletePersonalProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "employeeNumber", "deletePersonalProfile");
        PersonalProfileValidatorRequestBody requestBody = new PersonalProfileValidatorRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deletePersonalProfile", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}/delete", requestBody, this.serverName, userId, profileGUID);
        this.exceptionHandler.detectAndThrowNoProfileForUserException("deletePersonalProfile", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowStandardExceptions("deletePersonalProfile", (FFDCResponseBase)restResult);
    }

    public long getKarmaPoints(String userId, String profileUserId) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        return 0L;
    }

    public List<ContactMethod> getContactDetails(String userId, String profileUserId) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public String addContactMethod(String userId, String profileUserId, ContactMethodType type, String service, String value) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void deleteContactMethod(String userId, String profileUserId, String contactMethodGUID, ContactMethodType type) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
    }

    public PersonalProfile getPersonalProfileByGUID(String userId, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}";
        String guidParameterName = "profileGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getPersonalProfileByGUID");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileByGUID");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "getPersonalProfileByGUID");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileByGUID", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}", this.serverName, userId, profileGUID);
        this.exceptionHandler.detectAndThrowStandardExceptions("getPersonalProfileByGUID", (FFDCResponseBase)restResult);
        return restResult.getPersonalProfile();
    }

    public PersonalProfile getPersonalProfileForUser(String userId, String profileUserId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileForUser";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-user/{2}";
        String profileUserIdParameterName = "profileUserId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getPersonalProfileForUser");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileForUser");
        this.invalidParameterHandler.validateName(profileUserId, "profileUserId", "getPersonalProfileForUser");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileForUser", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-user/{2}", this.serverName, userId, profileUserId);
        this.exceptionHandler.detectAndThrowStandardExceptions("getPersonalProfileForUser", (FFDCResponseBase)restResult);
        return restResult.getPersonalProfile();
    }

    public PersonalProfile getPersonalProfileByQualifiedName(String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByQualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-qualified-name/{2}";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getPersonalProfileByQualifiedName");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileByQualifiedName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getPersonalProfileByQualifiedName");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileByQualifiedName", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-qualified-name/{2}", this.serverName, userId, qualifiedName);
        return restResult.getPersonalProfile();
    }

    public List<PersonalProfile> getPersonalProfilesByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfilesByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-name/{2}";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.omasServerURL, this.serverName, "getPersonalProfilesByName");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfilesByName");
        this.invalidParameterHandler.validateName(name, "name", "getPersonalProfilesByName");
        PersonalProfileListResponse restResult = this.restClient.callPersonalProfileListGetRESTCall("getPersonalProfilesByName", this.omasServerURL + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-name/{2}", this.serverName, userId, name);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getPersonalProfiles();
    }
}

