/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.api.PersonalProfileManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.PersonalProfileUniverse;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodType;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class PersonalProfileManagement
implements PersonalProfileManagementInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private CommunityProfileRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public PersonalProfileManagement(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot);
    }

    public PersonalProfileManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public PersonalProfileManagement(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public PersonalProfileManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public PersonalProfileManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createPersonalProfile(String userId, String externalSourceGUID, String externalSourceName, String profileUserId, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles";
        String profileUserIdParameterName = "profileUserId";
        String qualifiedParameterName = "qualifiedName";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "createPersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "createPersonalProfile");
        this.invalidParameterHandler.validateName(profileUserId, "profileUserId", "createPersonalProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createPersonalProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "createPersonalProfile");
        PersonalProfileRequestBody requestBody = new PersonalProfileRequestBody();
        requestBody.setOriginatingSystemGUID(externalSourceGUID);
        requestBody.setOriginatingSystemName(externalSourceName);
        requestBody.setProfileUserId(profileUserId);
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPersonalProfile", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles", requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updatePersonalProfile(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> profileProperties, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updatePersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}";
        String guidParameterName = "profileGUID";
        String qualifiedNameParameterName = "qualifiedName";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "updatePersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "updatePersonalProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "updatePersonalProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updatePersonalProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "updatePersonalProfile");
        PersonalProfileRequestBody requestBody = new PersonalProfileRequestBody();
        requestBody.setOriginatingSystemGUID(externalSourceGUID);
        requestBody.setOriginatingSystemName(externalSourceName);
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setProfileProperties(profileProperties);
        requestBody.setAdditionalProperties(additionalProperties);
        this.restClient.callVoidPostRESTCall("updatePersonalProfile", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}", requestBody, new Object[]{this.serverName, userId, profileGUID});
    }

    public void deletePersonalProfile(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deletePersonalProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}/delete";
        String guidParameterName = "profileGUID";
        String employeeNumberParameterName = "employeeNumber";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "deletePersonalProfile");
        this.invalidParameterHandler.validateUserId(userId, "deletePersonalProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "deletePersonalProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "employeeNumber", "deletePersonalProfile");
        PersonalProfileValidatorRequestBody requestBody = new PersonalProfileValidatorRequestBody();
        requestBody.setOriginatingSystemGUID(externalSourceGUID);
        requestBody.setOriginatingSystemName(externalSourceName);
        this.restClient.callVoidPostRESTCall("deletePersonalProfile", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}/delete", requestBody, new Object[]{this.serverName, userId, profileGUID});
    }

    public long getKarmaPoints(String userId, String profileUserId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return 0L;
    }

    public List<ContactMethodProperties> getContactMethods(String userId, String profileUserId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public String addContactMethod(String userId, String externalSourceGUID, String externalSourceName, String profileUserId, ContactMethodType type, String service, String value) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void deleteContactMethod(String userId, String externalSourceGUID, String externalSourceName, String profileUserId, String contactMethodGUID, ContactMethodType type) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    public PersonalProfileUniverse getPersonalProfileByGUID(String userId, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}";
        String guidParameterName = "profileGUID";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getPersonalProfileByGUID");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileByGUID");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "getPersonalProfileByGUID");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/{2}", this.serverName, userId, profileGUID);
        return restResult.getPersonalProfile();
    }

    public PersonalProfileUniverse getPersonalProfileForUser(String userId, String profileUserId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileForUser";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-user/{2}";
        String profileUserIdParameterName = "profileUserId";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getPersonalProfileForUser");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileForUser");
        this.invalidParameterHandler.validateName(profileUserId, "profileUserId", "getPersonalProfileForUser");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileForUser", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-user/{2}", this.serverName, userId, profileUserId);
        return restResult.getPersonalProfile();
    }

    public PersonalProfileUniverse getPersonalProfileByQualifiedName(String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByQualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-qualified-name";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getPersonalProfileByQualifiedName");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfileByQualifiedName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getPersonalProfileByQualifiedName");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getPersonalProfileByQualifiedName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-qualified-name", this.serverName, userId, qualifiedName);
        return restResult.getPersonalProfile();
    }

    public List<PersonalProfileUniverse> getPersonalProfilesByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfilesByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-name";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getPersonalProfilesByName");
        this.invalidParameterHandler.validateUserId(userId, "getPersonalProfilesByName");
        this.invalidParameterHandler.validateName(name, "name", "getPersonalProfilesByName");
        PersonalProfileListResponse restResult = this.restClient.callPersonalProfileListGetRESTCall("getPersonalProfilesByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/personal-profiles/by-name", this.serverName, userId, name);
        return restResult.getPersonalProfiles();
    }
}

