/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.UserIdentityManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.UserIdentityElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserIdentityProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.UserIdentityListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.UserIdentityRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.UserIdentityResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class UserIdentityManagement
implements UserIdentityManagementInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private CommunityProfileRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities";

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot);
    }

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createUserIdentity(String userId, String externalSourceGUID, String externalSourceName, UserIdentityProperties newIdentity) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createUserIdentity";
        String propertiesParameterName = "newIdentity";
        String qualifiedNameParameterName = "newIdentity.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createUserIdentity");
        this.invalidParameterHandler.validateObject((Object)newIdentity, "newIdentity", "createUserIdentity");
        this.invalidParameterHandler.validateName(newIdentity.getQualifiedName(), "newIdentity.qualifiedName", "createUserIdentity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities";
        UserIdentityRequestBody requestBody = new UserIdentityRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(newIdentity);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createUserIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, boolean isMergeUpdate, UserIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateUserIdentity";
        String guidParameterName = "userIdentityGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateUserIdentity");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "updateUserIdentity");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateUserIdentity");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateUserIdentity");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities" + "/{2}?isMergeUpdate={3}";
        UserIdentityRequestBody requestBody = new UserIdentityRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("updateUserIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID, isMergeUpdate});
    }

    public void deleteUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteUserIdentity";
        String guidParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteUserIdentity");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "deleteUserIdentity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities" + "/{2}";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("deleteUserIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID});
    }

    public void addIdentityToProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addIdentityToProfile";
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "addIdentityToProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "addIdentityToProfile");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "addIdentityToProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities" + "/{2}/profiles/{3}/link";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("addIdentityToProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID, profileGUID});
    }

    public void removeIdentityFromProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeIdentityFromProfile";
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeIdentityFromProfile");
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", "removeIdentityFromProfile");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "removeIdentityFromProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities" + "/{2}/profiles/{3}/unlink";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("removeIdentityFromProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID, profileGUID});
    }

    public List<UserIdentityElement> findUserIdentities(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findUserIdentities";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findUserIdentities");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findUserIdentities");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities" + "/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        UserIdentityListResponse restResult = this.restClient.callUserIdentityListPostRESTCall("findUserIdentities", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<UserIdentityElement> getUserIdentitiesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getUserIdentitiesByName";
        String namePropertyName = "qualifiedName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getUserIdentitiesByName");
        this.invalidParameterHandler.validateName(name, "name", "getUserIdentitiesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities" + "/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("qualifiedName");
        requestBody.setNameParameterName("name");
        UserIdentityListResponse restResult = this.restClient.callUserIdentityListPostRESTCall("getUserIdentitiesByName", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public UserIdentityElement getUserIdentityByGUID(String userId, String userIdentityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getUserIdentityByGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "getUserIdentityByGUID");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "getUserIdentityByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities" + "/{2}";
        UserIdentityResponse restResult = this.restClient.callUserIdentityGetRESTCall("getUserIdentityByGUID", urlTemplate, this.serverName, userId, userIdentityGUID);
        return restResult.getElement();
    }
}

