/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.LocationManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.LocationElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.LocationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.DigitalLocationRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.FixedLocationRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.LocationResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.LocationsResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.SecureLocationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class LocationManagement
implements LocationManagementInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private CommunityProfileRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public LocationManagement(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot);
    }

    public LocationManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public LocationManagement(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public LocationManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public LocationManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createLocation(String userId, LocationProperties locationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLocation";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "locationProperties";
        this.invalidParameterHandler.validateUserId(userId, "createLocation");
        this.invalidParameterHandler.validateObject((Object)locationProperties, "locationProperties", "createLocation");
        this.invalidParameterHandler.validateName(locationProperties.getQualifiedName(), "qualifiedName", "createLocation");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createLocation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations", locationProperties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createLocationFromTemplate(String userId, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLocationFromTemplate";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createLocationFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createLocationFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createLocationFromTemplate");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createLocationFromTemplate", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/from-template/{2}", templateProperties, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateLocation(String userId, boolean isMergeUpdate, String locationGUID, LocationProperties locationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLocation";
        String guidParameter = "locationGUID";
        String propertiesParameter = "locationProperties";
        String qualifiedNameParameter = "locationProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateLocation");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "updateLocation");
        this.invalidParameterHandler.validateObject((Object)locationProperties, "locationProperties", "updateLocation");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(locationProperties.getQualifiedName(), "locationProperties.qualifiedName", "updateLocation");
        }
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/update?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateLocation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/update?isMergeUpdate={3}", locationProperties, new Object[]{this.serverName, userId, locationGUID, isMergeUpdate});
    }

    public void setLocationAsFixedPhysical(String userId, String locationGUID, String coordinates, String mapProjection, String postalAddress, String timeZone) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "setLocationAsFixedPhysical");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "setLocationAsFixedPhysical");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/classify-as-fixed-location";
        FixedLocationRequestBody requestBody = new FixedLocationRequestBody();
        requestBody.setCoordinates(coordinates);
        requestBody.setMapProjection(mapProjection);
        requestBody.setPostalAddress(postalAddress);
        requestBody.setTimeZone(timeZone);
        this.restClient.callVoidPostRESTCall("setLocationAsFixedPhysical", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/classify-as-fixed-location", requestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void clearLocationAsFixedPhysical(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearLocationAsFixedPhysical");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "clearLocationAsFixedPhysical");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-fixed-location/delete";
        this.restClient.callVoidPostRESTCall("clearLocationAsFixedPhysical", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-fixed-location/delete", this.nullRequestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void setLocationAsSecure(String userId, String locationGUID, String description, String level) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "setLocationAsSecure");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "setLocationAsSecure");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-secure-location";
        SecureLocationRequestBody requestBody = new SecureLocationRequestBody();
        requestBody.setDescription(description);
        requestBody.setLevel(level);
        this.restClient.callVoidPostRESTCall("setLocationAsSecure", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-secure-location", requestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void clearLocationAsSecure(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearLocationAsSecure");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "clearLocationAsSecure");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-secure-location/delete";
        this.restClient.callVoidPostRESTCall("clearLocationAsSecure", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-secure-location/delete", this.nullRequestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void setLocationAsDigital(String userId, String locationGUID, String networkAddress) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "setLocationAsDigital");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "setLocationAsDigital");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-digital-location";
        DigitalLocationRequestBody requestBody = new DigitalLocationRequestBody();
        requestBody.setNetworkAddress(networkAddress);
        this.restClient.callVoidPostRESTCall("setLocationAsDigital", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-digital-location", requestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void clearLocationAsDigital(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearLocationAsDigital");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "clearLocationAsDigital");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-digital-location/delete";
        this.restClient.callVoidPostRESTCall("clearLocationAsDigital", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-digital-location/delete", this.nullRequestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void removeLocation(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeLocation";
        String guidParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeLocation");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "removeLocation");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/delete";
        this.restClient.callVoidPostRESTCall("removeLocation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void setupNestedLocation(String userId, String parentLocationGUID, String childLocationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupNestedLocation");
        this.invalidParameterHandler.validateGUID(parentLocationGUID, "parentLocationGUID", "setupNestedLocation");
        this.invalidParameterHandler.validateGUID(childLocationGUID, "childLocationGUID", "setupNestedLocation");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/has-nested-location/{3}";
        this.restClient.callVoidPostRESTCall("setupNestedLocation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/has-nested-location/{3}", this.nullRequestBody, new Object[]{this.serverName, userId, parentLocationGUID, childLocationGUID});
    }

    public void clearNestedLocation(String userId, String parentLocationGUID, String childLocationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearNestedLocation");
        this.invalidParameterHandler.validateGUID(parentLocationGUID, "parentLocationGUID", "clearNestedLocation");
        this.invalidParameterHandler.validateGUID(childLocationGUID, "childLocationGUID", "clearNestedLocation");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/has-nested-location/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearNestedLocation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/has-nested-location/{3}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, parentLocationGUID, childLocationGUID});
    }

    public void setupAdjacentLocation(String userId, String locationOneGUID, String locationTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupAdjacentLocation");
        this.invalidParameterHandler.validateGUID(locationOneGUID, "locationOneGUID", "setupAdjacentLocation");
        this.invalidParameterHandler.validateGUID(locationTwoGUID, "locationTwoGUID", "setupAdjacentLocation");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-peer-location/{3}";
        this.restClient.callVoidPostRESTCall("setupAdjacentLocation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-peer-location/{3}", this.nullRequestBody, new Object[]{this.serverName, userId, locationOneGUID, locationTwoGUID});
    }

    public void clearAdjacentLocation(String userId, String locationOneGUID, String locationTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearAdjacentLocation");
        this.invalidParameterHandler.validateGUID(locationOneGUID, "locationOneGUID", "clearAdjacentLocation");
        this.invalidParameterHandler.validateGUID(locationTwoGUID, "locationTwoGUID", "clearAdjacentLocation");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-peer-location/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearAdjacentLocation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-peer-location/{3}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, locationOneGUID, locationTwoGUID});
    }

    public List<LocationElement> findLocations(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findLocations";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findLocations");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findLocations");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findLocations");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        LocationsResponse restResult = this.restClient.callLocationsPostRESTCall("findLocations", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<LocationElement> getLocationsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLocationsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getLocationsByName");
        this.invalidParameterHandler.validateName(name, "name", "getLocationsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLocationsByName");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        LocationsResponse restResult = this.restClient.callLocationsPostRESTCall("getLocationsByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/by-name?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public LocationElement getLocationByGUID(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLocationByGUID";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLocationByGUID");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "getLocationByGUID");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}";
        LocationResponse restResult = this.restClient.callLocationGetRESTCall("getLocationByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}", this.serverName, userId, locationGUID);
        return restResult.getElement();
    }
}

