/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.CommunityManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileBaseClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.CommunityElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommunityMembershipProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommunityProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.CommunityListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.CommunityResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class CommunityManagement
extends CommunityProfileBaseClient
implements CommunityManagementInterface {
    private static final String communityURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities";

    public CommunityManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public CommunityManagement(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public CommunityManagement(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public CommunityManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public CommunityManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createCommunity(String userId, String externalSourceGUID, String externalSourceName, CommunityProperties communityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createCommunity";
        String propertiesParameterName = "communityProperties";
        String urlTemplate = this.serverPlatformURLRoot + communityURLTemplatePrefix;
        return super.createReferenceable(userId, externalSourceGUID, externalSourceName, (ReferenceableProperties)communityProperties, "communityProperties", urlTemplate, "createCommunity");
    }

    public String createCommunityFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createCommunityFromTemplate";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities/from-template/{2}";
        return super.createReferenceableFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateProperties, urlTemplate, "createCommunityFromTemplate");
    }

    public void updateCommunity(String userId, String externalSourceGUID, String externalSourceName, String communityGUID, boolean isMergeUpdate, CommunityProperties communityProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateCommunity";
        String elementGUIDParameterName = "communityGUID";
        String propertiesParameterName = "communityProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities/{2}?isMergeUpdate={3}";
        super.updateReferenceable(userId, externalSourceGUID, externalSourceName, communityGUID, "communityGUID", isMergeUpdate, (ReferenceableProperties)communityProperties, "communityProperties", urlTemplate, "updateCommunity");
    }

    public void setupCommunityRole(String userId, String externalSourceGUID, String externalSourceName, String communityGUID, CommunityMembershipProperties membershipProperties, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupCommunityRole";
        String communityGUIDParameterName = "communityGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities/{2}/community-roles/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, communityGUID, "communityGUID", (RelationshipProperties)membershipProperties, personRoleGUID, "personRoleGUID", urlTemplate, "setupCommunityRole");
    }

    public void clearCommunityRole(String userId, String externalSourceGUID, String externalSourceName, String communityGUID, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearCommunityRole";
        String communityGUIDParameterName = "communityGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities/{2}/community-roles/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, communityGUID, "communityGUID", personRoleGUID, "personRoleGUID", urlTemplate, "clearCommunityRole");
    }

    public void removeCommunity(String userId, String externalSourceGUID, String externalSourceName, String communityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeCommunity";
        String elementGUIDParameterName = "communityGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities/{2}/delete";
        super.removeReferenceable(userId, externalSourceGUID, externalSourceName, communityGUID, "communityGUID", urlTemplate, "removeCommunity");
    }

    public List<CommunityElement> findCommunities(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findCommunity";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findCommunity");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findCommunity");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findCommunity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        CommunityListResponse restResult = this.restClient.callCommunityListPostRESTCall("findCommunity", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<CommunityElement> getCommunitiesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCommunityByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getCommunityByName");
        this.invalidParameterHandler.validateName(name, "name", "getCommunityByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCommunityByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        CommunityListResponse restResult = this.restClient.callCommunityListPostRESTCall("getCommunityByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<CommunityElement> getCommunities(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCommunities";
        this.invalidParameterHandler.validateUserId(userId, "getCommunities");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCommunities");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities?startFrom={2}&pageSize={3}";
        CommunityListResponse restResult = this.restClient.callCommunityListGetRESTCall("getCommunities", urlTemplate, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<PersonRoleElement> getRolesForCommunity(String userId, String communityGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRolesForCommunity";
        String guidPropertyName = "communityGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRolesForCommunity");
        this.invalidParameterHandler.validateGUID(communityGUID, "communityGUID", "getRolesForCommunity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities/person-roles/by-community/{2}?startFrom={3}&pageSize={4}";
        PersonRoleListResponse restResult = this.restClient.callPersonRoleListGetRESTCall("getRolesForCommunity", urlTemplate, this.serverName, userId, communityGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public CommunityElement getCommunityByGUID(String userId, String communityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCommunityByGUID";
        String guidParameterName = "communityGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCommunityByGUID");
        this.invalidParameterHandler.validateGUID(communityGUID, "communityGUID", "getCommunityByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/communities/{2}";
        CommunityResponse restResult = this.restClient.callCommunityGetRESTCall("getCommunityByGUID", urlTemplate, this.serverName, userId, communityGUID);
        return restResult.getElement();
    }
}

