/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.api.MyPersonalProfileInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.AssetCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.PersonalProfileUniverse;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodType;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MyProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.CountResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class MyProfileManagement
implements MyPersonalProfileInterface {
    private final String serverName;
    private final String serverPlatformURLRoot;
    private final CommunityProfileRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public MyProfileManagement(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot);
    }

    public MyProfileManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public MyProfileManagement(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public MyProfileManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public MyProfileManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public PersonalProfileUniverse getMyProfile(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMyProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile";
        this.invalidParameterHandler.validateUserId(userId, "getMyProfile");
        PersonalProfileResponse restResult = this.restClient.callPersonalProfileGetRESTCall("getMyProfile", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile", userId);
        return restResult.getPersonalProfile();
    }

    public long getMyKarmaPoints(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMyKarmaPoints";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/karma-points";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getMyKarmaPoints");
        this.invalidParameterHandler.validateUserId(userId, "getMyKarmaPoints");
        CountResponse restResult = this.restClient.callCountGetRESTCall("getMyKarmaPoints", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/karma-points", new Object[]{userId});
        return restResult.getCount();
    }

    public void setUpMyProfile(String userId, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "setUpMyProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile";
        String qualifiedNameParameterName = "qualifiedName";
        String knownNameParameterName = "knownName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "setUpMyProfile");
        this.invalidParameterHandler.validateUserId(userId, "setUpMyProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "setUpMyProfile");
        this.invalidParameterHandler.validateName(knownName, "knownName", "setUpMyProfile");
        MyProfileRequestBody requestBody = new MyProfileRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        this.restClient.callGUIDPostRESTCall("setUpMyProfile", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile", requestBody, new Object[]{this.serverName, userId});
    }

    public void deleteMyProfile(String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteMyProfile";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/delete";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "deleteMyProfile");
        this.invalidParameterHandler.validateUserId(userId, "deleteMyProfile");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteMyProfile");
        PersonalProfileValidatorRequestBody requestBody = new PersonalProfileValidatorRequestBody();
        this.restClient.callVoidPostRESTCall("deleteMyProfile", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/my-profile/delete", requestBody, new Object[]{this.serverName, userId});
    }

    public List<ContactMethodElement> getMyContactDetails(String UserId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public String addMyContactMethod(String userId, ContactMethodType type, String service, String value) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void deleteMyContactMethod(String userId, String contactMethodGUID, ContactMethodType type) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    public List<AssetCollectionMember> getMyAssets(String userId, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void addToMyAssets(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    public void removeFromMyAssets(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }
}

