/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.OrganizationManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.PersonRoleAppointee;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ActorProfileProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.AppointmentProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContributionRecord;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonRoleProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ActorProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ActorProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ActorProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ContactMethodRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.EffectiveDatesRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleAppointeeListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.TeamPlayerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class OrganizationManagement
implements OrganizationManagementInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private CommunityProfileRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations";

    public OrganizationManagement(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot);
    }

    public OrganizationManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public OrganizationManagement(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public OrganizationManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public OrganizationManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createActorProfile(String userId, String externalSourceGUID, String externalSourceName, ActorProfileProperties properties, ContributionRecord contributionRecord) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createActorProfile";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createActorProfile");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createActorProfile");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createActorProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles";
        ActorProfileRequestBody requestBody = new ActorProfileRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        requestBody.setContributionRecord(contributionRecord);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createActorProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateActorProfile(String userId, String externalSourceGUID, String externalSourceName, String actorProfileGUID, boolean isMergeUpdate, ActorProfileProperties properties, ContributionRecord contributionRecord) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateActorProfile";
        String guidParameterName = "actorProfileGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateActorProfile");
        this.invalidParameterHandler.validateGUID(actorProfileGUID, "actorProfileGUID", "updateActorProfile");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateActorProfile");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateActorProfile");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/{2}?isMergeUpdate={3}";
        ActorProfileRequestBody requestBody = new ActorProfileRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        requestBody.setContributionRecord(contributionRecord);
        this.restClient.callVoidPostRESTCall("updateActorProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, actorProfileGUID, isMergeUpdate});
    }

    public void deleteActorProfile(String userId, String externalSourceGUID, String externalSourceName, String actorProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteActorProfile";
        String guidParameterName = "actorProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteActorProfile");
        this.invalidParameterHandler.validateGUID(actorProfileGUID, "actorProfileGUID", "deleteActorProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("deleteActorProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, actorProfileGUID});
    }

    public String addContactMethod(String userId, String externalSourceGUID, String externalSourceName, String actorProfileGUID, ContactMethodProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addContactMethod";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "addContactMethod");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "addContactMethod");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/{2}/contact-methods";
        ContactMethodRequestBody requestBody = new ContactMethodRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addContactMethod", urlTemplate, requestBody, new Object[]{this.serverName, userId, actorProfileGUID});
        return restResult.getGUID();
    }

    public void deleteContactMethod(String userId, String externalSourceGUID, String externalSourceName, String contactMethodGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteContactMethod";
        String guidParameterName = "contactMethodGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteContactMethod");
        this.invalidParameterHandler.validateGUID(contactMethodGUID, "contactMethodGUID", "deleteContactMethod");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/contact-methods/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("deleteContactMethod", urlTemplate, requestBody, new Object[]{this.serverName, userId, contactMethodGUID});
    }

    public void linkTeamsInHierarchy(String userId, String externalSourceGUID, String externalSourceName, String superTeamProfileGUID, String subTeamProfileGUID, boolean delegationEscalationAuthority, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkTeamsInHierarchy";
        String profileGUIDParameterName = "superTeamProfileGUID";
        String subTeamGUIDParameterName = "subTeamProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkTeamsInHierarchy");
        this.invalidParameterHandler.validateGUID(superTeamProfileGUID, "superTeamProfileGUID", "linkTeamsInHierarchy");
        this.invalidParameterHandler.validateGUID(subTeamProfileGUID, "subTeamProfileGUID", "linkTeamsInHierarchy");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/{2}/sub-team-profiles/{3}/link?delegationEscalationAuthority={4}";
        EffectiveDatesRequestBody requestBody = new EffectiveDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        this.restClient.callVoidPostRESTCall("linkTeamsInHierarchy", urlTemplate, requestBody, new Object[]{this.serverName, userId, superTeamProfileGUID, subTeamProfileGUID, delegationEscalationAuthority});
    }

    public void unlinkTeamsInHierarchy(String userId, String externalSourceGUID, String externalSourceName, String superTeamProfileGUID, String subTeamProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkTeamsInHierarchy";
        String profileGUIDParameterName = "superTeamProfileGUID";
        String subTeamGUIDParameterName = "subTeamProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "unlinkTeamsInHierarchy");
        this.invalidParameterHandler.validateGUID(superTeamProfileGUID, "superTeamProfileGUID", "unlinkTeamsInHierarchy");
        this.invalidParameterHandler.validateGUID(subTeamProfileGUID, "subTeamProfileGUID", "unlinkTeamsInHierarchy");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/{2}/sub-team-profiles/{3}/unlink";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("unlinkTeamsInHierarchy", urlTemplate, requestBody, new Object[]{this.serverName, userId, superTeamProfileGUID, subTeamProfileGUID});
    }

    public ActorProfileElement getActorProfileByGUID(String userId, String actorProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActorProfileByGUID";
        String guidParameterName = "actorProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "getActorProfileByGUID");
        this.invalidParameterHandler.validateGUID(actorProfileGUID, "actorProfileGUID", "getActorProfileByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/{2}";
        ActorProfileResponse restResult = this.restClient.callActorProfileGetRESTCall("getActorProfileByGUID", urlTemplate, this.serverName, userId, actorProfileGUID);
        return restResult.getElement();
    }

    public ActorProfileElement getActorProfileByUserId(String userId, String actorProfileUserId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActorProfileByGUID";
        String nameParameterName = "actorProfileUserId";
        this.invalidParameterHandler.validateUserId(userId, "getActorProfileByGUID");
        this.invalidParameterHandler.validateName(actorProfileUserId, "actorProfileUserId", "getActorProfileByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/user-ids/{2}";
        ActorProfileResponse restResult = this.restClient.callActorProfileGetRESTCall("getActorProfileByGUID", urlTemplate, this.serverName, userId, actorProfileUserId);
        return restResult.getElement();
    }

    public List<ActorProfileElement> getActorProfileByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActorProfileByName";
        String namePropertyName = "name";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getActorProfileByName");
        this.invalidParameterHandler.validateName(name, "name", "getActorProfileByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        requestBody.setNameParameterName("name");
        ActorProfileListResponse restResult = this.restClient.callActorProfileListPostRESTCall("getActorProfileByName", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<ActorProfileElement> findActorProfile(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findActorProfile";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findActorProfile");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findActorProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/profiles/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ActorProfileListResponse restResult = this.restClient.callActorProfileListPostRESTCall("findActorProfile", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public String createPersonRole(String userId, String externalSourceGUID, String externalSourceName, PersonRoleProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPersonRole";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.roleId";
        this.invalidParameterHandler.validateUserId(userId, "createPersonRole");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createPersonRole");
        this.invalidParameterHandler.validateName(properties.getRoleId(), "properties.roleId", "createPersonRole");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles";
        PersonRoleRequestBody requestBody = new PersonRoleRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createPersonRole", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updatePersonRole(String userId, String externalSourceGUID, String externalSourceName, String personRoleGUID, boolean isMergeUpdate, PersonRoleProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePersonRole";
        String guidParameterName = "personRoleGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.roleId";
        this.invalidParameterHandler.validateUserId(userId, "updatePersonRole");
        this.invalidParameterHandler.validateGUID(personRoleGUID, "personRoleGUID", "updatePersonRole");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updatePersonRole");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getRoleId(), "properties.roleId", "updatePersonRole");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles/{2}?isMergeUpdate={3}";
        PersonRoleRequestBody requestBody = new PersonRoleRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("updatePersonRole", urlTemplate, requestBody, new Object[]{this.serverName, userId, personRoleGUID, isMergeUpdate});
    }

    public void deletePersonRole(String userId, String externalSourceGUID, String externalSourceName, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deletePersonRole";
        String guidParameterName = "personRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "deletePersonRole");
        this.invalidParameterHandler.validateGUID(personRoleGUID, "personRoleGUID", "deletePersonRole");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("deletePersonRole", urlTemplate, requestBody, new Object[]{this.serverName, userId, personRoleGUID});
    }

    public String linkPersonRoleToProfile(String userId, String externalSourceGUID, String externalSourceName, String personRoleGUID, String personProfileGUID, AppointmentProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkPersonRoleToProfile";
        String profileGUIDParameterName = "personProfileGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkPersonRoleToProfile");
        this.invalidParameterHandler.validateGUID(personProfileGUID, "personProfileGUID", "linkPersonRoleToProfile");
        this.invalidParameterHandler.validateGUID(personRoleGUID, "personRoleGUID", "linkPersonRoleToProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles/{2}/profiles/{3}/link";
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("linkPersonRoleToProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, personRoleGUID, personProfileGUID});
        return response.getGUID();
    }

    public List<PersonRoleAppointee> getAppointees(String userId, String personRoleGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAppointees";
        String personRoleGUIDParameterName = "personRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAppointees");
        this.invalidParameterHandler.validateGUID(personRoleGUID, "personRoleGUID", "getAppointees");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles/{2}/appointees?startFrom={3}&pageSize={4}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        PersonRoleAppointeeListResponse restResult = this.restClient.callPersonRoleAppointeeListPostRESTCall("getAppointees", urlTemplate, requestBody, this.serverName, userId, personRoleGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public void updateAppointment(String userId, String externalSourceGUID, String externalSourceName, String appointmentGUID, boolean isMergeUpdate, AppointmentProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePersonRole";
        String guidParameterName = "personRoleGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updatePersonRole");
        this.invalidParameterHandler.validateGUID(appointmentGUID, "personRoleGUID", "updatePersonRole");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updatePersonRole");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles/appointees/{2}?isMergeUpdate={3}";
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("updatePersonRole", urlTemplate, requestBody, new Object[]{this.serverName, userId, appointmentGUID, isMergeUpdate});
    }

    public void unlinkPersonRoleFromProfile(String userId, String externalSourceGUID, String externalSourceName, String appointmentGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkPersonRoleFromProfile";
        String guidParameterName = "appointmentGUID";
        this.invalidParameterHandler.validateUserId(userId, "unlinkPersonRoleFromProfile");
        this.invalidParameterHandler.validateGUID(appointmentGUID, "appointmentGUID", "unlinkPersonRoleFromProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles/appointees/{2}/unlink";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("unlinkPersonRoleFromProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, appointmentGUID});
    }

    public void linkTeamPlayer(String userId, String externalSourceGUID, String externalSourceName, String teamRoleGUID, String teamProfileGUID, String position, boolean leadershipPosition) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkTeamPlayer";
        String profileGUIDParameterName = "teamProfileGUID";
        String personRoleGUIDParameterName = "teamRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkTeamPlayer");
        this.invalidParameterHandler.validateGUID(teamProfileGUID, "teamProfileGUID", "linkTeamPlayer");
        this.invalidParameterHandler.validateGUID(teamRoleGUID, "teamRoleGUID", "linkTeamPlayer");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/team-profiles/{2}/team-roles/{3}/link";
        TeamPlayerRequestBody requestBody = new TeamPlayerRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setPosition(position);
        requestBody.setIsLeadershipRole(leadershipPosition);
        this.restClient.callVoidPostRESTCall("linkTeamPlayer", urlTemplate, requestBody, new Object[]{this.serverName, userId, teamProfileGUID, teamRoleGUID});
    }

    public void unlinkTeamPlayer(String userId, String externalSourceGUID, String externalSourceName, String teamRoleGUID, String teamProfileGUID, boolean leadershipPosition) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkTeamPlayer";
        String profileGUIDParameterName = "teamProfileGUID";
        String personRoleGUIDParameterName = "teamRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "unlinkTeamPlayer");
        this.invalidParameterHandler.validateGUID(teamProfileGUID, "teamProfileGUID", "unlinkTeamPlayer");
        this.invalidParameterHandler.validateGUID(teamRoleGUID, "teamRoleGUID", "unlinkTeamPlayer");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/team-profiles/{2}/team-roles/{3}/unlink";
        TeamPlayerRequestBody requestBody = new TeamPlayerRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setIsLeadershipRole(leadershipPosition);
        this.restClient.callVoidPostRESTCall("unlinkTeamPlayer", urlTemplate, requestBody, new Object[]{this.serverName, userId, teamProfileGUID, teamRoleGUID});
    }

    public PersonRoleElement getPersonRoleByGUID(String userId, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPersonRoleByGUID";
        String guidParameterName = "personRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPersonRoleByGUID");
        this.invalidParameterHandler.validateGUID(personRoleGUID, "personRoleGUID", "getPersonRoleByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles/{2}";
        PersonRoleResponse restResult = this.restClient.callPersonRoleGetRESTCall("getPersonRoleByGUID", urlTemplate, this.serverName, userId, personRoleGUID);
        return restResult.getElement();
    }

    public List<PersonRoleElement> getPersonRoleByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPersonRoleByName";
        String namePropertyName = "name";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getPersonRoleByName");
        this.invalidParameterHandler.validateName(name, "name", "getPersonRoleByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        requestBody.setNameParameterName("name");
        PersonRoleListResponse restResult = this.restClient.callPersonRoleListPostRESTCall("getPersonRoleByName", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    public List<PersonRoleElement> findPersonRole(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findPersonRole";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findPersonRole");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findPersonRole");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/organizations/person-roles/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        PersonRoleListResponse restResult = this.restClient.callPersonRoleListPostRESTCall("findPersonRole", urlTemplate, requestBody, this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }
}

