/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.ValidValueManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileBaseClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ValidValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ValidValueMembershipProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ValidValueProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ValidValueListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ValidValueResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ValidValueManagement
extends CommunityProfileBaseClient
implements ValidValueManagementInterface {
    private static final String validValueURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values";

    public ValidValueManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public ValidValueManagement(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public ValidValueManagement(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public ValidValueManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ValidValueManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createValidValue(String userId, String externalSourceGUID, String externalSourceName, ValidValueProperties validValueProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValue";
        String propertiesParameterName = "validValueProperties";
        String urlTemplate = this.serverPlatformURLRoot + validValueURLTemplatePrefix;
        return super.createReferenceable(userId, externalSourceGUID, externalSourceName, (ReferenceableProperties)validValueProperties, "validValueProperties", urlTemplate, "createValidValue");
    }

    public void updateValidValue(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, boolean isMergeUpdate, ValidValueProperties validValueProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateValidValue";
        String elementGUIDParameterName = "validValueGUID";
        String propertiesParameterName = "validValueProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}?isMergeUpdate={3}";
        super.updateReferenceable(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", isMergeUpdate, (ReferenceableProperties)validValueProperties, "validValueProperties", urlTemplate, "updateValidValue");
    }

    public void setupValidValueMember(String userId, String externalSourceGUID, String externalSourceName, String validValueSetGUID, ValidValueMembershipProperties properties, String validValueMemberGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupValidValueMember";
        String validValueSetGUIDParameterName = "validValueSetGUID";
        String validValueMemberGUIDParameterName = "validValueMemberGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}/valid-value-members/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, validValueSetGUID, "validValueSetGUID", (RelationshipProperties)properties, validValueMemberGUID, "validValueMemberGUID", urlTemplate, "setupValidValueMember");
    }

    public void clearValidValueMember(String userId, String externalSourceGUID, String externalSourceName, String validValueSetGUID, String validValueMemberGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidValueMember";
        String validValueSetGUIDParameterName = "validValueSetGUID";
        String validValueMemberGUIDParameterName = "validValueMemberGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}/valid-value-members/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, validValueSetGUID, "validValueSetGUID", validValueMemberGUID, "validValueMemberGUID", urlTemplate, "clearValidValueMember");
    }

    public void setupValidValues(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, ValidValueAssignmentProperties properties, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupValidValues";
        String elementGUIDParameterName = "elementGUID";
        String validValueGUIDParameterName = "validValueGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}/valid-values/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", (RelationshipProperties)properties, validValueGUID, "validValueGUID", urlTemplate, "setupValidValues");
    }

    public void clearValidValues(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidValues";
        String elementGUIDParameterName = "elementGUID";
        String validValueGUIDParameterName = "validValueGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}/valid-values/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", validValueGUID, "validValueGUID", urlTemplate, "clearValidValues");
    }

    public void setupReferenceValueTag(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, ReferenceValueAssignmentProperties properties, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupReferenceValueTag";
        String elementGUIDParameterName = "elementGUID";
        String validValueGUIDParameterName = "validValueGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}/reference-value-tags/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", (RelationshipProperties)properties, validValueGUID, "validValueGUID", urlTemplate, "setupReferenceValueTag");
    }

    public void clearReferenceValueTag(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearReferenceValueTag";
        String elementGUIDParameterName = "elementGUID";
        String validValueGUIDParameterName = "validValueGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}/reference-value-tags/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", validValueGUID, "validValueGUID", urlTemplate, "clearReferenceValueTag");
    }

    public void removeValidValue(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeValidValue";
        String elementGUIDParameterName = "validValueGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}/delete";
        super.removeReferenceable(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", urlTemplate, "removeValidValue");
    }

    public List<ValidValueElement> findValidValues(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findValidValue";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findValidValue");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findValidValue");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findValidValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ValidValueListResponse restResult = this.restClient.callValidValueListPostRESTCall("findValidValue", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> getValidValuesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByName");
        this.invalidParameterHandler.validateName(name, "name", "getValidValueByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValueByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ValidValueListResponse restResult = this.restClient.callValidValueListPostRESTCall("getValidValueByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> getAllValidValues(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValues";
        this.invalidParameterHandler.validateUserId(userId, "getValidValues");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValues");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values?startFrom={2}&pageSize={3}";
        ValidValueListResponse restResult = this.restClient.callValidValueListGetRESTCall("getValidValues", urlTemplate, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> getValidValueSetMembers(String userId, String validValueSetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueSetMembers";
        String guidParameterName = "validValueSetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueSetMembers");
        this.invalidParameterHandler.validateGUID(validValueSetGUID, "validValueSetGUID", "getValidValueSetMembers");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValueSetMembers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/members/{2}?startFrom={3}&pageSize={4}";
        ValidValueListResponse restResult = this.restClient.callValidValueListGetRESTCall("getValidValueSetMembers", urlTemplate, this.serverName, userId, validValueSetGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> getSetsForValidValue(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueSetMembers";
        String guidParameterName = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueSetMembers");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValueSetMembers");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValueSetMembers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/sets/{2}?startFrom={3}&pageSize={4}";
        ValidValueListResponse restResult = this.restClient.callValidValueListGetRESTCall("getValidValueSetMembers", urlTemplate, this.serverName, userId, validValueGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public ValidValueElement getValidValuesForConsumer(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValuesForConsumer";
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValuesForConsumer");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getValidValuesForConsumer");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/by-consumer/{2}";
        ValidValueResponse restResult = this.restClient.callValidValueGetRESTCall("getValidValuesForConsumer", urlTemplate, this.serverName, userId, elementGUID);
        return restResult.getElement();
    }

    public List<RelatedElement> getConsumersOfValidValue(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConsumersOfValidValue";
        String guidPropertyName = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConsumersOfValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getConsumersOfValidValue");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConsumersOfValidValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}/consumers?startFrom={3}&pageSize={4}";
        RelatedElementListResponse restResult = this.restClient.callRelatedElementListGetRESTCall("getConsumersOfValidValue", urlTemplate, this.serverName, userId, validValueGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> getReferenceValues(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getReferenceValues";
        this.invalidParameterHandler.validateUserId(userId, "getReferenceValues");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getReferenceValues");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/by-reference-value-tags/{2}?startFrom={3}&pageSize={4}";
        ValidValueListResponse restResult = this.restClient.callValidValueListGetRESTCall("getReferenceValues", urlTemplate, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<RelatedElement> getAssigneesOfReferenceValue(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssigneesOfReferenceValue";
        String guidPropertyName = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssigneesOfReferenceValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getAssigneesOfReferenceValue");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAssigneesOfReferenceValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}/by-reference-value-tag-assignees?startFrom={3}&pageSize={4}";
        RelatedElementListResponse restResult = this.restClient.callRelatedElementListGetRESTCall("getAssigneesOfReferenceValue", urlTemplate, this.serverName, userId, validValueGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public ValidValueElement getValidValueByGUID(String userId, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByGUID";
        String guidParameterName = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByGUID");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValueByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/valid-values/{2}";
        ValidValueResponse restResult = this.restClient.callValidValueGetRESTCall("getValidValueByGUID", urlTemplate, this.serverName, userId, validValueGUID);
        return restResult.getElement();
    }
}

