/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.SecurityGroupInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileBaseClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.SecurityGroupElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.SecurityGroupProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ElementStubsResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.SecurityGroupResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.SecurityGroupsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

public class SecurityGroupManagement
extends CommunityProfileBaseClient
implements SecurityGroupInterface {
    private final NullRequestBody nullRequestBody = new NullRequestBody();

    public SecurityGroupManagement(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public SecurityGroupManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public SecurityGroupManagement(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public SecurityGroupManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public SecurityGroupManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createSecurityGroup(String userId, SecurityGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSecurityGroup";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/security-groups";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "createSecurityGroup");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createSecurityGroup");
        this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "createSecurityGroup");
        this.invalidParameterHandler.validateName(properties.getTitle(), "title", "createSecurityGroup");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSecurityGroup", urlTemplate, properties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateSecurityGroup(String userId, String securityGroupGUID, boolean isMergeUpdate, SecurityGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSecurityGroup";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/security-groups/{2}/update?isMergeUpdate={3}";
        String guidParameterName = "securityGroupGUID";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateSecurityGroup");
        this.invalidParameterHandler.validateGUID(securityGroupGUID, "securityGroupGUID", "updateSecurityGroup");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateSecurityGroup");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "updateSecurityGroup");
            this.invalidParameterHandler.validateName(properties.getTitle(), "title", "updateSecurityGroup");
        }
        this.restClient.callVoidPostRESTCall("updateSecurityGroup", urlTemplate, properties, new Object[]{this.serverName, userId, securityGroupGUID, isMergeUpdate});
    }

    public void deleteSecurityGroup(String userId, String securityGroupGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteSecurityGroup";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/security-groups/{2}/delete";
        String guidParameterName = "securityGroupGUID";
        this.invalidParameterHandler.validateGUID(securityGroupGUID, "securityGroupGUID", "deleteSecurityGroup");
        this.invalidParameterHandler.validateUserId(userId, "deleteSecurityGroup");
        this.restClient.callVoidPostRESTCall("deleteSecurityGroup", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, securityGroupGUID});
    }

    public List<SecurityGroupElement> getSecurityGroupsForDistinguishedName(String userId, String distinguishedName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSecurityGroupsForDistinguishedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/security-groups/for-distinguished-name/{2}?startFrom={3}&pageSize={4}";
        String parameterName = "distinguishedName";
        this.invalidParameterHandler.validateUserId(userId, "getSecurityGroupsForDistinguishedName");
        this.invalidParameterHandler.validateName("distinguishedName", "distinguishedName", "getSecurityGroupsForDistinguishedName");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSecurityGroupsForDistinguishedName");
        SecurityGroupsResponse restResult = this.restClient.callSecurityGroupsGetRESTCall("getSecurityGroupsForDistinguishedName", urlTemplate, this.serverName, userId, distinguishedName, startFrom, queryPageSize);
        return restResult.getElementList();
    }

    public List<ElementStub> getElementsGovernedBySecurityGroup(String userId, String securityGroupGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsGovernedBySecurityGroup";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/security-groups/{2}/governed-by/elements?startFrom={3}&pageSize={4}";
        String guidParameterName = "securityGroupGUID";
        this.invalidParameterHandler.validateUserId(userId, "getElementsGovernedBySecurityGroup");
        this.invalidParameterHandler.validateGUID(securityGroupGUID, "securityGroupGUID", "getElementsGovernedBySecurityGroup");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getElementsGovernedBySecurityGroup");
        ElementStubsResponse restResult = this.restClient.callElementStubsGetRESTCall("getElementsGovernedBySecurityGroup", urlTemplate, this.serverName, userId, securityGroupGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }

    public List<SecurityGroupElement> findSecurityGroups(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSecurityGroups";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/security-groups/by-search-string?startFrom={2}&pageSize={3}";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "findSecurityGroups");
        this.invalidParameterHandler.validateUserId(userId, "findSecurityGroups");
        this.invalidParameterHandler.validateSearchString(searchString, searchString, "findSecurityGroups");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSecurityGroups");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        SecurityGroupsResponse restResult = this.restClient.callSecurityGroupsPostRESTCall("findSecurityGroups", urlTemplate, requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElementList();
    }

    public SecurityGroupElement getSecurityGroupByGUID(String userId, String securityGroupGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSecurityGroupByGUID";
        String securityGroupGUIDParameterName = "securityGroupGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSecurityGroupByGUID");
        this.invalidParameterHandler.validateGUID(securityGroupGUID, "securityGroupGUID", "getSecurityGroupByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/{2}";
        SecurityGroupResponse restResult = this.restClient.callSecurityGroupGetRESTCall("getSecurityGroupByGUID", urlTemplate, this.serverName, userId, securityGroupGUID);
        return restResult.getElement();
    }
}

