/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.RelatedElementsManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.AssignmentScopeProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ResourceListProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.StakeholderProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;

public class CommunityProfileBaseClient
implements RelatedElementsManagementInterface {
    final String serverName;
    final String serverPlatformURLRoot;
    final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    final CommunityProfileRESTClient restClient;
    protected final PropertyHelper propertyHelper = new PropertyHelper();
    protected final OpenMetadataStoreClient openMetadataStoreClient;
    protected static final String baseURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}";
    private static final String elementsURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements";

    public CommunityProfileBaseClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, maxPageSize);
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public CommunityProfileBaseClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, maxPageSize);
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot);
    }

    public CommunityProfileBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public CommunityProfileBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.restClient = new CommunityProfileRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public CommunityProfileBaseClient(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, maxPageSize);
        this.restClient = restClient;
    }

    String createReferenceable(String userId, String externalSourceGUID, String externalSourceName, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    String createReferenceableFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, TemplateProperties templateProperties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    String createReferenceableWithParent(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, String parentGUIDParameterName, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentGUID, parentGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setParentGUID(parentGUID);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    void updateReferenceable(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, boolean isMergeUpdate, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        }
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID, isMergeUpdate});
    }

    void setReferenceableClassification(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameter, ClassificationProperties properties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ClassificationRequestBody requestBody = new ClassificationRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void removeReferenceableClassification(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameter, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void setupRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    void setupRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, boolean isMergeUpdate, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID, isMergeUpdate});
    }

    public void updateRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, boolean isMergeUpdate, String urlTemplate, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID, isMergeUpdate});
    }

    void clearRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    List<RelatedElement> getRelatedElements(String userId, String startingElementGUID, String startingElementGUIDParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        RelatedElementListResponse restResult = this.restClient.callRelatedElementListGetRESTCall(methodName, urlTemplate, this.serverName, userId, startingElementGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public void removeReferenceable(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    public void setupMoreInformation(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, RelationshipProperties properties, String detailGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/{2}/more-information/{3}";
        this.setupRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", properties, detailGUID, "detailGUID", urlTemplate, "setupMoreInformation");
    }

    public void clearMoreInformation(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String detailGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearMoreInformation";
        String elementGUIDParameterName = "elementGUID";
        String detailGUIDParameterName = "detailGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/{2}/more-information/{3}/delete";
        this.clearRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", detailGUID, "detailGUID", urlTemplate, "clearMoreInformation");
    }

    public List<RelatedElement> getMoreInformation(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMoreInformation";
        String guidPropertyName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/more-information/by-descriptive-element/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", urlTemplate, startFrom, pageSize, "getMoreInformation");
    }

    public List<RelatedElement> getDescriptiveElements(String userId, String detailGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDescriptiveElements";
        String guidPropertyName = "detailGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/more-information/by-detail-element/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, detailGUID, "detailGUID", urlTemplate, startFrom, pageSize, "getDescriptiveElements");
    }

    public void setupStakeholder(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, StakeholderProperties properties, String stakeholderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/{2}/stakeholders/{3}";
        this.setupRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", (RelationshipProperties)properties, stakeholderGUID, "stakeholderGUID", urlTemplate, "setupStakeholder");
    }

    public void clearStakeholder(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String stakeholderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearStakeholder";
        String elementGUIDParameterName = "elementGUID";
        String stakeholderGUIDParameterName = "stakeholderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/{2}/stakeholders/{3}/delete";
        this.clearRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", stakeholderGUID, "stakeholderGUID", urlTemplate, "clearStakeholder");
    }

    public List<RelatedElement> getStakeholders(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getStakeholders";
        String guidPropertyName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/stakeholders/by-commissioned-element/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", urlTemplate, startFrom, pageSize, "getStakeholders");
    }

    public List<RelatedElement> getStakeholderCommissionedElements(String userId, String stakeholderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getStakeholderCommissionedElements";
        String guidPropertyName = "stakeholderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/stakeholders/by-stakeholder/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, stakeholderGUID, "stakeholderGUID", urlTemplate, startFrom, pageSize, "getStakeholderCommissionedElements");
    }

    public void setupAssignmentScope(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, AssignmentScopeProperties properties, String scopeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/{2}/assignment-scopes/{3}";
        this.setupRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", (RelationshipProperties)properties, scopeGUID, "scopeGUID", urlTemplate, "setupAssignmentScope");
    }

    public void clearAssignmentScope(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String scopeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssignmentScope";
        String elementGUIDParameterName = "elementGUID";
        String scopeGUIDParameterName = "scopeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/{2}/assignment-scopes/{3}/delete";
        this.clearRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", scopeGUID, "scopeGUID", urlTemplate, "clearAssignmentScope");
    }

    public List<RelatedElement> getAssignedScopes(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssignedScopes";
        String guidPropertyName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/assignment-scopes/by-assigned-actor/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", urlTemplate, startFrom, pageSize, "getAssignedScopes");
    }

    public List<RelatedElement> getAssignedActors(String userId, String scopeGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssignedActors";
        String guidPropertyName = "scopeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/assignment-scopes/by-assigned-scope/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, scopeGUID, "scopeGUID", urlTemplate, startFrom, pageSize, "getAssignedActors");
    }

    public void setupResource(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, ResourceListProperties properties, String resourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/{2}/resource-list/{3}";
        this.setupRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", (RelationshipProperties)properties, resourceGUID, "resourceGUID", urlTemplate, "setupResource");
    }

    public void clearResource(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String resourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearResource";
        String elementGUIDParameterName = "elementGUID";
        String resourceGUIDParameterName = "resourceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/{2}/resource-list/{3}/delete";
        this.clearRelationship(userId, externalSourceGUID, externalSourceName, elementGUID, "elementGUID", resourceGUID, "resourceGUID", urlTemplate, "clearResource");
    }

    public List<RelatedElement> getResourceList(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getResourceList";
        String guidPropertyName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/resource-list/by-assignee/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, elementGUID, "elementGUID", urlTemplate, startFrom, pageSize, "getResourceList");
    }

    public List<RelatedElement> getSupportedByResource(String userId, String resourceGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSupportedByResource";
        String guidPropertyName = "resourceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/related-elements/resource-list/by-resource/{2}?startFrom={3}&pageSize={4}";
        return this.getRelatedElements(userId, resourceGUID, "resourceGUID", urlTemplate, startFrom, pageSize, "getSupportedByResource");
    }
}

