/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.LocationManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileBaseClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.LocationElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.AdjacentLocationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.AssetLocationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.DigitalLocationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.FixedLocationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.LocationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.NestedLocationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ProfileLocationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.SecureLocationProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.LocationListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.LocationResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class LocationManagement
extends CommunityProfileBaseClient
implements LocationManagementInterface {
    public LocationManagement(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public LocationManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public LocationManagement(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public LocationManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public LocationManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createLocation(String userId, String externalSourceGUID, String externalSourceName, LocationProperties locationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLocation";
        String propertiesParameter = "locationProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations";
        return super.createReferenceable(userId, externalSourceGUID, externalSourceName, (ReferenceableProperties)locationProperties, "locationProperties", urlTemplate, "createLocation");
    }

    public String createLocationFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLocationFromTemplate";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/from-template/{2}";
        return super.createReferenceableFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateProperties, urlTemplate, "createLocationFromTemplate");
    }

    public void updateLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, boolean isMergeUpdate, LocationProperties locationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLocation";
        String guidParameter = "locationGUID";
        String propertiesParameter = "locationProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/update?isMergeUpdate={3}";
        super.updateReferenceable(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", isMergeUpdate, (ReferenceableProperties)locationProperties, "locationProperties", urlTemplate, "updateLocation");
    }

    public void setLocationAsFixedPhysical(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, FixedLocationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/classify-as-fixed-location";
        super.setReferenceableClassification(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", (ClassificationProperties)properties, urlTemplate, "setLocationAsFixedPhysical");
    }

    public void clearLocationAsFixedPhysical(String userId, String externalSourceGUID, String externalSourceName, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-fixed-location/delete";
        super.removeReferenceableClassification(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", urlTemplate, "clearLocationAsFixedPhysical");
    }

    public void setLocationAsSecure(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, SecureLocationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-secure-location";
        super.setReferenceableClassification(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", (ClassificationProperties)properties, urlTemplate, "setLocationAsSecure");
    }

    public void clearLocationAsSecure(String userId, String externalSourceGUID, String externalSourceName, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-secure-location/delete";
        super.removeReferenceableClassification(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", urlTemplate, "clearLocationAsSecure");
    }

    public void setLocationAsDigital(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, DigitalLocationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-digital-location";
        super.setReferenceableClassification(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", (ClassificationProperties)properties, urlTemplate, "setLocationAsDigital");
    }

    public void clearLocationAsDigital(String userId, String externalSourceGUID, String externalSourceName, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/classify-as-digital-location/delete";
        super.removeReferenceableClassification(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", urlTemplate, "clearLocationAsDigital");
    }

    public void removeLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeLocation";
        String guidParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/delete";
        super.removeReferenceable(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", urlTemplate, "removeLocation");
    }

    public void setupNestedLocation(String userId, String externalSourceGUID, String externalSourceName, String parentLocationGUID, String childLocationGUID, NestedLocationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/has-nested-location/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, parentLocationGUID, "parentLocationGUID", (RelationshipProperties)properties, childLocationGUID, "childLocationGUID", urlTemplate, "setupNestedLocation");
    }

    public void clearNestedLocation(String userId, String externalSourceGUID, String externalSourceName, String parentLocationGUID, String childLocationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/has-nested-location/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, parentLocationGUID, "parentLocationGUID", childLocationGUID, "childLocationGUID", urlTemplate, "clearNestedLocation");
    }

    public void setupAdjacentLocation(String userId, String externalSourceGUID, String externalSourceName, String locationOneGUID, String locationTwoGUID, AdjacentLocationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-peer-location/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, locationOneGUID, "locationOneGUID", (RelationshipProperties)properties, locationTwoGUID, "locationTwoGUID", urlTemplate, "setupAdjacentLocation");
    }

    public void clearAdjacentLocation(String userId, String externalSourceGUID, String externalSourceName, String locationOneGUID, String locationTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-peer-location/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, locationOneGUID, "locationOneGUID", locationTwoGUID, "locationTwoGUID", urlTemplate, "clearAdjacentLocation");
    }

    public void setupProfileLocation(String userId, String externalSourceGUID, String externalSourceName, String actorProfileGUID, String locationGUID, ProfileLocationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProfileLocation";
        String actorGUIDParameter = "actorProfileGUID";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-actor-profiles/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", (RelationshipProperties)properties, actorProfileGUID, "actorProfileGUID", urlTemplate, "setupProfileLocation");
    }

    public void clearProfileLocation(String userId, String externalSourceGUID, String externalSourceName, String actorProfileGUID, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProfileLocation";
        String actorGUIDParameter = "actorProfileGUID";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-actor-profiles/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", actorProfileGUID, "actorProfileGUID", urlTemplate, "clearProfileLocation");
    }

    public void setupAssetLocation(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String locationGUID, AssetLocationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssetLocation";
        String actorGUIDParameter = "assetGUID";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-assets/{3}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", (RelationshipProperties)properties, assetGUID, "assetGUID", urlTemplate, "setupAssetLocation");
    }

    public void clearAssetLocation(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetLocation";
        String actorGUIDParameter = "assetGUID";
        String locationGUIDParameter = "locationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/linked-to-assets/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, locationGUID, "locationGUID", assetGUID, "assetGUID", urlTemplate, "clearAssetLocation");
    }

    public List<LocationElement> findLocations(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findLocations";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findLocations");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findLocations");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findLocations");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        LocationListResponse restResult = this.restClient.callLocationsPostRESTCall("findLocations", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<LocationElement> getLocationsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLocationsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getLocationsByName");
        this.invalidParameterHandler.validateName(name, "name", "getLocationsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLocationsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        LocationListResponse restResult = this.restClient.callLocationsPostRESTCall("getLocationsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<LocationElement> getAdjacentLocations(String userId, String locationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAdjacentLocations";
        String guidParameter = "actorProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAdjacentLocations");
        this.invalidParameterHandler.validateGUID(locationGUID, "actorProfileGUID", "getAdjacentLocations");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getAdjacentLocations");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/has-peer-locations?startFrom={3}&pageSize={4}";
        LocationListResponse restResult = this.restClient.callLocationsGetRESTCall("getAdjacentLocations", urlTemplate, this.serverName, userId, locationGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<LocationElement> getNestedLocations(String userId, String locationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNestedLocations";
        String guidParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "getNestedLocations");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "getNestedLocations");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNestedLocations");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/has-nested-locations?startFrom={3}&pageSize={4}";
        LocationListResponse restResult = this.restClient.callLocationsGetRESTCall("getNestedLocations", urlTemplate, this.serverName, userId, locationGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<LocationElement> getGroupingLocations(String userId, String locationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNestedLocations";
        String guidParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "getNestedLocations");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "getNestedLocations");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNestedLocations");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}/has-grouping-locations?startFrom={3}&pageSize={4}";
        LocationListResponse restResult = this.restClient.callLocationsGetRESTCall("getNestedLocations", urlTemplate, this.serverName, userId, locationGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<LocationElement> getLocationsByProfile(String userId, String actorProfileGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLocationsByProfile";
        String guidParameter = "actorProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLocationsByProfile");
        this.invalidParameterHandler.validateGUID(actorProfileGUID, "actorProfileGUID", "getLocationsByProfile");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLocationsByProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/by-actor-profile/{2}?startFrom={3}&pageSize={4}";
        LocationListResponse restResult = this.restClient.callLocationsGetRESTCall("getLocationsByProfile", urlTemplate, this.serverName, userId, actorProfileGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<LocationElement> getKnownLocationsForAsset(String userId, String assetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getKnownLocationsForAsset";
        String guidParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getKnownLocationsForAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getKnownLocationsForAsset");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getKnownLocationsForAsset");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/by-asset/{2}?startFrom={3}&pageSize={4}";
        LocationListResponse restResult = this.restClient.callLocationsGetRESTCall("getKnownLocationsForAsset", urlTemplate, this.serverName, userId, assetGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public List<LocationElement> getLocations(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLocations";
        this.invalidParameterHandler.validateUserId(userId, "getLocations");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLocations");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations?startFrom={2}&pageSize={3}";
        LocationListResponse restResult = this.restClient.callLocationsGetRESTCall("getLocations", urlTemplate, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    public LocationElement getLocationByGUID(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLocationByGUID";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLocationByGUID");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "getLocationByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/locations/{2}";
        LocationResponse restResult = this.restClient.callLocationGetRESTCall("getLocationByGUID", urlTemplate, this.serverName, userId, locationGUID);
        return restResult.getElement();
    }
}

