/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.ToDoManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileBaseClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.converters.ToDoConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ToDoElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ActionTargetProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.NewActionTargetProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ToDoProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public class ToDoActionManagement
extends CommunityProfileBaseClient
implements ToDoManagementInterface {
    private final ToDoConverter<ToDoElement> toDoConverter;
    private final Class<ToDoElement> toDoBeanClass = ToDoElement.class;

    public ToDoActionManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
        this.toDoConverter = new ToDoConverter(this.propertyHelper, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceName(), serverName);
    }

    public ToDoActionManagement(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
        this.toDoConverter = new ToDoConverter(this.propertyHelper, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceName(), serverName);
    }

    public ToDoActionManagement(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.toDoConverter = new ToDoConverter(this.propertyHelper, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceName(), serverName);
    }

    public ToDoActionManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
        this.toDoConverter = new ToDoConverter(this.propertyHelper, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceName(), serverName);
    }

    public String createToDo(String userId, String originatorGUID, String actionSponsorGUID, String assignToActorGUID, List<NewActionTargetProperties> newActionTargetProperties, ToDoProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String toDoGUID;
        String methodName = "createToDo";
        String toDoPropertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createToDo");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createToDo");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createToDo");
        String toDoTypeName = "ToDo";
        if (properties.getTypeName() != null) {
            toDoTypeName = properties.getTypeName();
        }
        if (properties.getCreationTime() == null) {
            properties.setCreationTime(new Date());
        }
        if ((toDoGUID = this.openMetadataStoreClient.createMetadataElementInStore(userId, null, null, toDoTypeName, ElementStatus.ACTIVE, null, null, true, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getToDoProperties(properties), originatorGUID, "ToDoSource", null, true)) != null) {
            if (assignToActorGUID != null) {
                this.openMetadataStoreClient.createRelatedElementsInStore(userId, null, null, "ActionAssignment", assignToActorGUID, toDoGUID, false, false, null, null, null, null);
            }
            if (actionSponsorGUID != null) {
                this.openMetadataStoreClient.createRelatedElementsInStore(userId, null, null, "ActionSponsor", actionSponsorGUID, toDoGUID, false, false, null, null, null, null);
            }
            if (newActionTargetProperties != null) {
                for (NewActionTargetProperties newActionTarget : newActionTargetProperties) {
                    if (newActionTarget == null) continue;
                    ElementProperties actionTargetProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ACTION_TARGET_NAME.name, newActionTarget.getActionTargetName());
                    this.openMetadataStoreClient.createRelatedElementsInStore(userId, null, null, "ActionTarget", toDoGUID, newActionTarget.getActionTargetGUID(), false, false, null, null, actionTargetProperties, null);
                }
            }
        }
        return toDoGUID;
    }

    public void updateToDo(String userId, String toDoGUID, boolean isMergeUpdate, ToDoProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateToDo";
        String collectionPropertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateToDo");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateToDo");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateToDo");
        }
        this.openMetadataStoreClient.updateMetadataElementInStore(userId, toDoGUID, !isMergeUpdate, false, false, this.getToDoProperties(properties), new Date());
    }

    public void updateActionTargetProperties(String userId, String actionTargetGUID, boolean isMergeUpdate, ActionTargetProperties actionTargetProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateActionTargetProperties";
        String propertiesName = "actionTargetProperties";
        this.invalidParameterHandler.validateUserId(userId, "updateActionTargetProperties");
        this.invalidParameterHandler.validateObject((Object)actionTargetProperties, "actionTargetProperties", "updateActionTargetProperties");
        this.openMetadataStoreClient.updateRelatedElementsInStore(userId, null, null, actionTargetGUID, !isMergeUpdate, false, false, this.getActionTargetProperties(actionTargetProperties), new Date());
    }

    public void reassignToDo(String userId, String toDoGUID, String actorGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "reassignToDo";
        String toDoGUIDParameterName = "toDoGUID";
        String parentGUIDParameterName = "actorGUID";
        this.invalidParameterHandler.validateUserId(userId, "reassignToDo");
        this.invalidParameterHandler.validateGUID(toDoGUID, "toDoGUID", "reassignToDo");
        this.invalidParameterHandler.validateGUID(actorGUID, "actorGUID", "reassignToDo");
        List assignedActors = this.openMetadataStoreClient.getRelatedMetadataElements(userId, toDoGUID, 1, "ActionAssignment", false, false, new Date(), 0, 0);
        if (assignedActors != null) {
            for (RelatedMetadataElement assignedActor : assignedActors) {
                this.openMetadataStoreClient.deleteRelatedElementsInStore(userId, null, null, assignedActor.getRelationshipGUID(), false, false, new Date());
            }
        }
        this.openMetadataStoreClient.createRelatedElementsInStore(userId, null, null, "ActionAssignment", toDoGUID, actorGUID, false, false, null, null, null, new Date());
    }

    public void deleteToDo(String userId, String toDoGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteToDo";
        String guidParameterName = "toDoGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteToDo");
        this.invalidParameterHandler.validateGUID(toDoGUID, "toDoGUID", "deleteToDo");
        this.openMetadataStoreClient.deleteMetadataElementInStore(userId, toDoGUID, false, false, new Date());
    }

    public ToDoElement getToDo(String userId, String toDoGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getToDo";
        String guidParameterName = "toDoGUID";
        this.invalidParameterHandler.validateUserId(userId, "getToDo");
        this.invalidParameterHandler.validateGUID(toDoGUID, "toDoGUID", "getToDo");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, toDoGUID, false, false, new Date());
        if (openMetadataElement != null && this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, "ToDo")) {
            List relatedMetadataElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 0, null, false, false, new Date(), 0, 0);
            return this.toDoConverter.getNewComplexBean(this.toDoBeanClass, openMetadataElement, relatedMetadataElements, "getToDo");
        }
        return null;
    }

    public List<ToDoElement> getActionsForActionTarget(String userId, String elementGUID, ToDoStatus toDoStatus, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getActionsForActionTarget";
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getActionsForActionTarget");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getActionsForActionTarget");
        List relatedMetadataElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, elementGUID, 2, "ActionTarget", false, false, new Date(), startFrom, pageSize);
        return this.convertRelatedToDos(userId, relatedMetadataElements, toDoStatus, "getActionsForActionTarget");
    }

    public List<ToDoElement> getActionsForSponsor(String userId, String elementGUID, ToDoStatus toDoStatus, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getActionsForSponsor";
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getActionsForSponsor");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getActionsForSponsor");
        List relatedMetadataElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, elementGUID, 1, "ActionSponsor", false, false, new Date(), startFrom, pageSize);
        return this.convertRelatedToDos(userId, relatedMetadataElements, toDoStatus, "getActionsForSponsor");
    }

    public List<ToDoElement> getAssignedActions(String userId, String actorGUID, ToDoStatus toDoStatus, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssignedActions";
        String guidParameterName = "actorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssignedActions");
        this.invalidParameterHandler.validateGUID(actorGUID, "actorGUID", "getAssignedActions");
        List relatedMetadataElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, actorGUID, 1, "ActionAssignment", false, false, new Date(), startFrom, pageSize);
        return this.convertRelatedToDos(userId, relatedMetadataElements, toDoStatus, "getAssignedActions");
    }

    public List<ToDoElement> findToDos(String userId, String searchString, ToDoStatus toDoStatus, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findToDos";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findToDos");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findToDos");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findToDos");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, "ToDo", false, false, new Date(), startFrom, pageSize);
        return this.convertToDos(userId, openMetadataElements, toDoStatus, "findToDos");
    }

    public List<ToDoElement> getToDosByType(String userId, String toDoType, ToDoStatus toDoStatus, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getToDosByType";
        this.invalidParameterHandler.validateUserId(userId, "getToDosByType");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getToDosByType");
        List<String> propertyNames = List.of("toDoType");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, "ToDo", null, this.propertyHelper.getSearchPropertiesByName(propertyNames, toDoType), null, null, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, new Date(), startFrom, pageSize);
        return this.convertToDos(userId, openMetadataElements, toDoStatus, "getToDosByType");
    }

    private List<ToDoElement> convertToDos(String userId, List<OpenMetadataElement> openMetadataElements, ToDoStatus toDoStatus, String methodName) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (openMetadataElements != null) {
            ArrayList<ToDoElement> toDoElements = new ArrayList<ToDoElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                List relatedMetadataElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 0, null, false, false, new Date(), 0, 0);
                ToDoElement toDoElement = this.toDoConverter.getNewComplexBean(this.toDoBeanClass, openMetadataElement, relatedMetadataElements, methodName);
                if (toDoStatus != null && toDoStatus != toDoElement.getProperties().getToDoStatus()) continue;
                toDoElements.add(toDoElement);
            }
            if (!toDoElements.isEmpty()) {
                return toDoElements;
            }
        }
        return null;
    }

    private List<ToDoElement> convertRelatedToDos(String userId, List<RelatedMetadataElement> relatedMetadataElements, ToDoStatus toDoStatus, String methodName) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (relatedMetadataElements != null) {
            ArrayList<ToDoElement> toDoElements = new ArrayList<ToDoElement>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements) {
                if (relatedMetadataElement == null) continue;
                List relatedElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, relatedMetadataElement.getElement().getElementGUID(), 0, null, false, false, new Date(), 0, 0);
                ToDoElement toDoElement = this.toDoConverter.getNewComplexBean(this.toDoBeanClass, relatedMetadataElement.getElement(), relatedElements, methodName);
                if (toDoStatus != null && toDoStatus != toDoElement.getProperties().getToDoStatus()) continue;
                toDoElements.add(toDoElement);
            }
            if (!toDoElements.isEmpty()) {
                return toDoElements;
            }
        }
        return null;
    }

    private ElementProperties getToDoProperties(ToDoProperties toDoProperties) {
        if (toDoProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, toDoProperties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAME.name, toDoProperties.getName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, toDoProperties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, "toDoType", toDoProperties.getToDoType());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, "priority", toDoProperties.getPriority());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, "creationTime", toDoProperties.getCreationTime());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, "lastReviewTime", toDoProperties.getLastReviewTime());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, "dueTime", toDoProperties.getDueTime());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, "completionTime", toDoProperties.getCompletionTime());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, toDoProperties.getAdditionalProperties());
            if (toDoProperties.getToDoStatus() != null) {
                elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.TO_DO_STATUS.name, ToDoStatus.getOpenTypeName(), toDoProperties.getToDoStatus().getName());
            }
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, toDoProperties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getActionTargetProperties(ActionTargetProperties actionTargetProperties) {
        if (actionTargetProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ACTION_TARGET_NAME.name, actionTargetProperties.getActionTargetName());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.START_DATE.name, actionTargetProperties.getStartDate());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.COMPLETION_DATE.name, actionTargetProperties.getCompletionDate());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.COMPLETION_MESSAGE.name, actionTargetProperties.getCompletionMessage());
            if (actionTargetProperties.getStatus() != null) {
                elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.TO_DO_STATUS.name, ToDoStatus.getOpenTypeName(), actionTargetProperties.getStatus().getName());
            }
            return elementProperties;
        }
        return null;
    }
}

