/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.communityprofile.client.converters.CommunityProfileConverterBase;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.CollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CollectionMembershipProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CollectionMembershipStatus;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public class CollectionMemberConverter<B>
extends CommunityProfileConverterBase<B> {
    public CollectionMemberConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, RelatedMetadataElement relatedMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CollectionMember) {
                CollectionMember bean = (CollectionMember)returnBean;
                CollectionMembershipProperties membershipProperties = new CollectionMembershipProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, (ElementControlHeader)relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, methodName));
                if (relatedMetadataElement.getRelationshipProperties() != null) {
                    ElementProperties elementProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
                    membershipProperties.setMembershipRationale(this.removeMembershipRationale(elementProperties));
                    membershipProperties.setCreatedBy(this.removeCreatedBy(elementProperties));
                    membershipProperties.setExpression(this.removeExpression(elementProperties));
                    membershipProperties.setConfidence(this.removeConfidence(elementProperties));
                    membershipProperties.setSteward(this.removeSteward(elementProperties));
                    membershipProperties.setStewardTypeName(this.removeStewardTypeName(elementProperties));
                    membershipProperties.setStewardPropertyName(this.removeStewardPropertyName(elementProperties));
                    membershipProperties.setSource(this.removeSource(elementProperties));
                    membershipProperties.setNotes(this.removeNotes(elementProperties));
                    membershipProperties.setStatus(this.removeCollectionMemberStatus(elementProperties));
                    membershipProperties.setEffectiveFrom(relatedMetadataElement.getEffectiveFromTime());
                    membershipProperties.setEffectiveTo(relatedMetadataElement.getEffectiveToTime());
                    membershipProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setElementHeader((ElementHeader)super.getElementStub(beanClass, relatedMetadataElement.getElement(), methodName));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    CollectionMembershipStatus removeCollectionMemberStatus(ElementProperties elementProperties) {
        String methodName = "removeCollectionMemberStatus";
        if (elementProperties != null) {
            String retrievedProperty = this.propertyHelper.removeEnumProperty(this.serviceName, OpenMetadataProperty.TO_DO_STATUS.name, elementProperties, "removeCollectionMemberStatus");
            for (CollectionMembershipStatus status : CollectionMembershipStatus.values()) {
                if (!status.getName().equals(retrievedProperty)) continue;
                return status;
            }
        }
        return null;
    }
}

