/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.client.converters.CommunityProfileConverterBase;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ActionTargetElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ToDoElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ActionTargetProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ToDoProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;

public class ToDoConverter<B>
extends CommunityProfileConverterBase<B> {
    public ToDoConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ToDoElement) {
                ToDoElement bean = (ToDoElement)returnBean;
                ToDoProperties toDoProperties = new ToDoProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                if (primaryElement != null) {
                    ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
                    toDoProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    toDoProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    toDoProperties.setName(this.removeName(elementProperties));
                    toDoProperties.setToDoType(this.removeToDoType(elementProperties));
                    toDoProperties.setDescription(this.removeDescription(elementProperties));
                    toDoProperties.setCreationTime(this.removeCreationTime(elementProperties));
                    toDoProperties.setPriority(this.removeIntPriority(elementProperties));
                    toDoProperties.setToDoStatus(super.removeToDoStatus(elementProperties));
                    toDoProperties.setLastReviewTime(this.removeLastReviewTime(elementProperties));
                    toDoProperties.setDueTime(this.removeDueTime(elementProperties));
                    toDoProperties.setCompletionTime(this.removeCompletionTime(elementProperties));
                    toDoProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
                    toDoProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
                    toDoProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    toDoProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                    bean.setProperties(toDoProperties);
                    if (relationships != null) {
                        ArrayList<ElementStub> assignedActors = new ArrayList<ElementStub>();
                        ArrayList<ElementStub> sponsors = new ArrayList<ElementStub>();
                        ArrayList<ActionTargetElement> actionTargets = new ArrayList<ActionTargetElement>();
                        for (RelatedMetadataElement relatedMetadataElement : relationships) {
                            if (relatedMetadataElement == null) continue;
                            if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, "ToDoSource")) {
                                bean.setToDoSource(super.getElementStub(beanClass, relatedMetadataElement.getElement(), methodName));
                                continue;
                            }
                            if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, "ActionAssignment")) {
                                assignedActors.add(super.getElementStub(beanClass, relatedMetadataElement.getElement(), methodName));
                                continue;
                            }
                            if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, "ActionSponsor")) {
                                sponsors.add(super.getElementStub(beanClass, relatedMetadataElement.getElement(), methodName));
                                continue;
                            }
                            if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, "ActionTarget")) continue;
                            ActionTargetElement actionTargetElement = new ActionTargetElement();
                            actionTargetElement.setTargetElement(relatedMetadataElement.getElement());
                            actionTargetElement.setRelationshipHeader(super.getMetadataElementHeader(beanClass, (ElementControlHeader)relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, methodName));
                            ActionTargetProperties actionTargetProperties = new ActionTargetProperties();
                            ElementProperties relationshipProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
                            actionTargetProperties.setActionTargetName(this.removeActionTargetName(relationshipProperties));
                            actionTargetProperties.setStatus(this.removeToDoStatus(relationshipProperties));
                            actionTargetProperties.setStartDate(this.removeStartDate(relationshipProperties));
                            actionTargetProperties.setCompletionDate(this.removeCompletionDate(relationshipProperties));
                            actionTargetProperties.setCompletionMessage(this.removeCompletionMessage(relationshipProperties));
                            actionTargetElement.setRelationshipProperties(actionTargetProperties);
                            actionTargets.add(actionTargetElement);
                        }
                        if (!assignedActors.isEmpty()) {
                            bean.setAssignedActors(assignedActors);
                        }
                        if (!sponsors.isEmpty()) {
                            bean.setSponsors(sponsors);
                        }
                        if (!actionTargets.isEmpty()) {
                            bean.setActionTargets(actionTargets);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(toDoProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

