/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import org.odpi.openmetadata.accessservices.communityprofile.api.MetadataSourceInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileBaseClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataSourceElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.MetadataSourceProperties;

public class MetadataSourceClient
extends CommunityProfileBaseClient
implements MetadataSourceInterface {
    private final NullRequestBody nullRequestBody = new NullRequestBody();
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/metadata-sources";

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createMetadataSource(String userId, MetadataSourceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataSource";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataSource");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createMetadataSource");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createMetadataSource");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/metadata-sources";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataSource", urlTemplate, properties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String getMetadataSourceGUID(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataSourceGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataSourceGUID");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getMetadataSourceGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/metadata-sources/by-name/{2}";
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getMetadataSourceGUID", urlTemplate, new Object[]{this.serverName, userId, qualifiedName});
        return restResult.getGUID();
    }

    public MetadataSourceElement getMetadataSource(String userId, String metadataSourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataSource";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataSource");
        this.invalidParameterHandler.validateGUID(metadataSourceGUID, "metadataSourceGUID", "getMetadataSource");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/metadata-sources/{2}";
        MetadataSourceResponse restResult = this.restClient.callMetadataSourceGetRESTCall("getMetadataSource", urlTemplate, new Object[]{this.serverName, userId, metadataSourceGUID});
        return restResult.getElement();
    }

    public void addUserProfileManagerClassification(String userId, String metadataSourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addUserProfileManagerClassification";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        this.invalidParameterHandler.validateUserId(userId, "addUserProfileManagerClassification");
        this.invalidParameterHandler.validateGUID(metadataSourceGUID, "metadataSourceGUID", "addUserProfileManagerClassification");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/metadata-sources/{2}/user-profile-manager";
        this.restClient.callVoidPostRESTCall("addUserProfileManagerClassification", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, metadataSourceGUID});
    }

    public void addUserAccessDirectoryClassification(String userId, String metadataSourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addUserAccessDirectoryClassification";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        this.invalidParameterHandler.validateUserId(userId, "addUserAccessDirectoryClassification");
        this.invalidParameterHandler.validateGUID(metadataSourceGUID, "metadataSourceGUID", "addUserAccessDirectoryClassification");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/metadata-sources/{2}/user-access-directory";
        this.restClient.callVoidPostRESTCall("addUserAccessDirectoryClassification", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, metadataSourceGUID});
    }

    public void addMasterDataManagerClassification(String userId, String metadataSourceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addMasterDataManagerClassification";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        this.invalidParameterHandler.validateUserId(userId, "addMasterDataManagerClassification");
        this.invalidParameterHandler.validateGUID(metadataSourceGUID, "metadataSourceGUID", "addMasterDataManagerClassification");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/metadata-sources/{2}/master-data-manager";
        this.restClient.callVoidPostRESTCall("addMasterDataManagerClassification", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, metadataSourceGUID});
    }
}

