/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.CollectionManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileBaseClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionMemberResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionMembersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionMember;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionFolderProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;

public class CollectionManagement
extends CommunityProfileBaseClient
implements CollectionManagementInterface {
    private static final String collectionURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections";

    public CollectionManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public CollectionManagement(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public CollectionManagement(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public CollectionManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public CollectionManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createCollection(String userId, String externalSourceGUID, String externalSourceName, CollectionProperties collectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createCollection";
        String propertiesParameterName = "collectionProperties";
        String urlTemplate = this.serverPlatformURLRoot + collectionURLTemplatePrefix;
        return super.createReferenceable(userId, externalSourceGUID, externalSourceName, (ReferenceableProperties)collectionProperties, "collectionProperties", urlTemplate, "createCollection");
    }

    public String createFolderCollection(String userId, String externalSourceGUID, String externalSourceName, CollectionFolderProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createFolderCollection";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/folders";
        return super.createReferenceable(userId, externalSourceGUID, externalSourceName, (ReferenceableProperties)properties, "properties", urlTemplate, "createFolderCollection");
    }

    public void updateCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, boolean isMergeUpdate, CollectionProperties collectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateCollection";
        String elementGUIDParameterName = "collectionGUID";
        String propertiesParameterName = "collectionProperties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/{2}?isMergeUpdate={3}";
        super.updateReferenceable(userId, externalSourceGUID, externalSourceName, collectionGUID, "collectionGUID", isMergeUpdate, (ReferenceableProperties)collectionProperties, "collectionProperties", urlTemplate, "updateCollection");
    }

    public void updateCollectionMembership(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, CollectionMembershipProperties membershipProperties, boolean isMergeUpdate, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateCollectionMembership";
        String collectionGUIDParameterName = "collectionGUID";
        String memberGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/{2}/collection-roles/{3}?isMergeUpdate={4}";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, collectionGUID, "collectionGUID", isMergeUpdate, (RelationshipProperties)membershipProperties, elementGUID, "elementGUID", urlTemplate, "updateCollectionMembership");
    }

    public void removeFromCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeFromCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String memberGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/{2}/collection-roles/{3}/delete";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, collectionGUID, "collectionGUID", elementGUID, "elementGUID", urlTemplate, "removeFromCollection");
    }

    public void removeCollection(String userId, String externalSourceGUID, String externalSourceName, String collectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeCollection";
        String elementGUIDParameterName = "collectionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/{2}/delete";
        super.removeReferenceable(userId, externalSourceGUID, externalSourceName, collectionGUID, "collectionGUID", urlTemplate, "removeCollection");
    }

    public List<CollectionElement> findCollections(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findCollections";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findCollections");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findCollections");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findCollections");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        CollectionsResponse restResult = this.restClient.callCollectionListPostRESTCall("findCollections", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<CollectionElement> getCollectionsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCollectionByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionByName");
        this.invalidParameterHandler.validateName(name, "name", "getCollectionByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCollectionByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        CollectionsResponse restResult = this.restClient.callCollectionListPostRESTCall("getCollectionByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<CollectionElement> getCollections(String userId, String parentGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCollections";
        String guidPropertyName = "parentGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCollections");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "getCollections");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCollections");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections?startFrom={2}&pageSize={3}";
        CollectionsResponse restResult = this.restClient.callCollectionListGetRESTCall("getCollections", urlTemplate, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<CollectionMember> getCollectionMembers(String userId, String collectionGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCollectionMembers";
        String guidPropertyName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionMembers");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "getCollectionMembers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/{2}/membership?startFrom={3}&pageSize={4}";
        CollectionMembersResponse restResult = this.restClient.callCollectionMemberListGetRESTCall("getCollectionMembers", urlTemplate, new Object[]{this.serverName, userId, collectionGUID, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public CollectionMember getCollectionMember(String userId, String collectionGUID, String memberGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollectionMembers";
        String guidPropertyName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionMembers");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "getCollectionMembers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/{2}/members/{3}?startFrom={3}&pageSize={4}";
        CollectionMemberResponse restResult = this.restClient.callCollectionMemberGetRESTCall("getCollectionMembers", urlTemplate, new Object[]{this.serverName, userId, collectionGUID, memberGUID});
        return restResult.getElement();
    }

    public List<CollectionElement> getElementsCollections(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsCollections";
        String guidPropertyName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getElementsCollections");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getElementsCollections");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/elements/{2}/collections?startFrom={3}&pageSize={4}";
        CollectionsResponse restResult = this.restClient.callCollectionListGetRESTCall("getElementsCollections", urlTemplate, new Object[]{this.serverName, userId, elementGUID, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public CollectionElement getCollection(String userId, String collectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCollection";
        String guidParameterName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "getCollection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/collections/{2}";
        CollectionResponse restResult = this.restClient.callCollectionGetRESTCall("getCollection", urlTemplate, new Object[]{this.serverName, userId, collectionGUID});
        return restResult.getElement();
    }
}

