/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.UserIdentityManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileBaseClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentitiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentityResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ProfileIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.UserIdentityProperties;

public class UserIdentityManagement
extends CommunityProfileBaseClient
implements UserIdentityManagementInterface {
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities";

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog, maxPageSize);
    }

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog, maxPageSize);
    }

    public UserIdentityManagement(String serverName, String serverPlatformURLRoot, CommunityProfileRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createUserIdentity(String userId, String externalSourceGUID, String externalSourceName, UserIdentityProperties newIdentity) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createUserIdentity";
        String propertiesParameterName = "newIdentity";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities";
        return super.createReferenceable(userId, externalSourceGUID, externalSourceName, (ReferenceableProperties)newIdentity, "newIdentity", urlTemplate, "createUserIdentity");
    }

    public String createUserIdentityForProfile(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, UserIdentityProperties newIdentity) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createUserIdentityForProfile";
        String guidParameterName = "profileGUID";
        String propertiesParameterName = "newIdentity";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities";
        return super.createReferenceableWithParent(userId, externalSourceGUID, externalSourceName, profileGUID, "profileGUID", (ReferenceableProperties)newIdentity, "newIdentity", urlTemplate, "createUserIdentityForProfile");
    }

    public void updateUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, boolean isMergeUpdate, UserIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateUserIdentity";
        String guidParameterName = "userIdentityGUID";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities/{2}?isMergeUpdate={3}";
        super.updateReferenceable(userId, externalSourceGUID, externalSourceName, userIdentityGUID, "userIdentityGUID", isMergeUpdate, (ReferenceableProperties)properties, "properties", urlTemplate, "updateUserIdentity");
    }

    public void deleteUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteUserIdentity";
        String guidParameterName = "userIdentityGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities/{2}/delete";
        super.removeReferenceable(userId, externalSourceGUID, externalSourceName, userIdentityGUID, "userIdentityGUID", urlTemplate, "deleteUserIdentity");
    }

    public void addIdentityToProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String profileGUID, ProfileIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addIdentityToProfile";
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities/{2}/profiles/{3}/link";
        super.setupRelationship(userId, externalSourceGUID, externalSourceName, userIdentityGUID, "userIdentityGUID", (RelationshipProperties)properties, profileGUID, "profileGUID", urlTemplate, "addIdentityToProfile");
    }

    public void updateProfileIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String profileGUID, boolean isMergeUpdate, ProfileIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateProfileIdentity";
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities/{2}/profiles/{3}/link/update?isMergeUpdate={4}";
        super.updateRelationship(userId, externalSourceGUID, externalSourceName, userIdentityGUID, "userIdentityGUID", (RelationshipProperties)properties, profileGUID, "profileGUID", isMergeUpdate, urlTemplate, "updateProfileIdentity");
    }

    public void removeIdentityFromProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeIdentityFromProfile";
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities/{2}/profiles/{3}/unlink";
        super.clearRelationship(userId, externalSourceGUID, externalSourceName, userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", urlTemplate, "removeIdentityFromProfile");
    }

    public List<UserIdentityElement> findUserIdentities(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findUserIdentities";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findUserIdentities");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findUserIdentities");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        UserIdentitiesResponse restResult = this.restClient.callUserIdentitiesPostRESTCall("findUserIdentities", urlTemplate, requestBody, new Object[]{this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public List<UserIdentityElement> getUserIdentitiesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getUserIdentitiesByName";
        String namePropertyName = "qualifiedName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getUserIdentitiesByName");
        this.invalidParameterHandler.validateName(name, "name", "getUserIdentitiesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("qualifiedName");
        requestBody.setNameParameterName("name");
        UserIdentitiesResponse restResult = this.restClient.callUserIdentitiesPostRESTCall("getUserIdentitiesByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public UserIdentityElement getUserIdentityByGUID(String userId, String userIdentityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getUserIdentityByGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "getUserIdentityByGUID");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "getUserIdentityByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/community-profile/users/{1}/user-identities/{2}";
        UserIdentityResponse restResult = this.restClient.callUserIdentityGetRESTCall("getUserIdentityByGUID", urlTemplate, new Object[]{this.serverName, userId, userIdentityGUID});
        return restResult.getElement();
    }
}

