/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.communityprofile.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.MyProfileManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.PersonalProfileManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.UserIdentityManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceCode(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceName(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceDescription(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceWiki());
        thisTest.testMetadataSourceClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testUserIdentityManagement(serverName, serverPlatformRootURL, auditLog);
        thisTest.testMyProfileManagement(serverName, serverPlatformRootURL, auditLog);
        thisTest.testPersonalProfileManagement(serverName, serverPlatformRootURL, auditLog);
    }

    private void testMetadataSourceClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new MetadataSourceClient(serverName, serverPlatformRootURL, auditLog);
        new MetadataSourceClient(serverName, serverPlatformRootURL);
        new MetadataSourceClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new MetadataSourceClient(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        CommunityProfileRESTClient restClient = new CommunityProfileRESTClient(serverName, serverPlatformRootURL);
        new MetadataSourceClient(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testUserIdentityManagement(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new UserIdentityManagement(serverName, serverPlatformRootURL, auditLog);
        new UserIdentityManagement(serverName, serverPlatformRootURL);
        new UserIdentityManagement(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new UserIdentityManagement(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        CommunityProfileRESTClient restClient = new CommunityProfileRESTClient(serverName, serverPlatformRootURL);
        new UserIdentityManagement(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testMyProfileManagement(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new MyProfileManagement(serverName, serverPlatformRootURL, auditLog);
        new MyProfileManagement(serverName, serverPlatformRootURL);
        new MyProfileManagement(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new MyProfileManagement(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        CommunityProfileRESTClient restClient = new CommunityProfileRESTClient(serverName, serverPlatformRootURL);
        new MyProfileManagement(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testPersonalProfileManagement(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new PersonalProfileManagement(serverName, serverPlatformRootURL, auditLog);
        new PersonalProfileManagement(serverName, serverPlatformRootURL);
        new PersonalProfileManagement(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new PersonalProfileManagement(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        CommunityProfileRESTClient restClient = new CommunityProfileRESTClient(serverName, serverPlatformRootURL);
        new PersonalProfileManagement(serverName, serverPlatformRootURL, restClient, 100);
    }
}

