/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.fvt.errorhandling;

import java.util.HashMap;
import org.odpi.openmetadata.accessservices.communityprofile.client.MyProfileManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class InvalidParameterTest {
    private static final String testCaseName = "InvalidParameterTest";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            InvalidParameterTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        InvalidParameterTest thisTest = new InvalidParameterTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceCode(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceName(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceDescription(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceWiki());
        thisTest.testMyProfileClient(serverName, serverPlatformRootURL, userId, auditLog);
    }

    private void testMyProfileClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testMyProfileClient";
        try {
            CommunityProfileRESTClient restClient = new CommunityProfileRESTClient(serverName, serverPlatformRootURL, auditLog);
            MyProfileManagement client = new MyProfileManagement(serverName, serverPlatformRootURL, restClient, 100);
            this.testGetMyProfile(client);
            this.testGetMyKarmaPoints(client);
            this.testSetUpMyProfile(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testMyProfileClient", (Throwable)unexpectedError);
        }
    }

    private void testGetMyProfile(MyProfileManagement client) throws FVTUnexpectedCondition {
        String activityName = "testGetMyProfile";
        try {
            this.testGetMyProfileNoUserId(client);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyProfile", (Throwable)unexpectedError);
        }
    }

    private void testGetMyProfileNoUserId(MyProfileManagement client) throws FVTUnexpectedCondition {
        String activityName = "testGetMyProfileNoUserId";
        try {
            client.getMyProfile(null);
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyProfileNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyProfileNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testGetMyKarmaPoints(MyProfileManagement client) throws FVTUnexpectedCondition {
        String activityName = "testGetMyKarmaPoints";
        try {
            this.testGetMyKarmaPointsNoUserId(client);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyKarmaPoints", (Throwable)unexpectedError);
        }
    }

    private void testGetMyKarmaPointsNoUserId(MyProfileManagement client) throws FVTUnexpectedCondition {
        String activityName = "testGetMyKarmaPointsNoUserId";
        try {
            client.getMyKarmaPoints(null);
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyKarmaPointsNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyKarmaPointsNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testSetUpMyProfile(String userId, MyProfileManagement client) throws FVTUnexpectedCondition {
        String activityName = "testSetUpMyProfileNoUserId";
        try {
            this.testSetUpMyProfileNoUserId(client);
            this.testSetUpMyProfileNoQualifiedName(client, userId);
            this.testSetUpMyProfileNoKnownName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpMyProfileNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testSetUpMyProfileNoUserId(MyProfileManagement client) throws FVTUnexpectedCondition {
        String activityName = "testSetUpMyProfileNoUserId";
        try {
            client.setUpMyProfile(null, "qualifiedName", "fullName", "knownName", "jobTitle", "jobRoleDescription", new HashMap());
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpMyProfileNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpMyProfileNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testSetUpMyProfileNoQualifiedName(MyProfileManagement client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testSetUpMyProfileNoQualifiedName";
        try {
            client.setUpMyProfile(userId, null, "fullName", "knownName", "jobTitle", "jobRoleDescription", new HashMap());
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpMyProfileNoQualifiedName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpMyProfileNoQualifiedName", (Throwable)unexpectedError);
        }
    }

    private void testSetUpMyProfileNoKnownName(MyProfileManagement client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testSetUpMyProfileNoKnownName";
        try {
            client.setUpMyProfile(userId, "qualifiedName", "fullName", null, "jobTitle", "jobRoleDescription", new HashMap());
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpMyProfileNoKnownName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpMyProfileNoKnownName", (Throwable)unexpectedError);
        }
    }
}

