/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.fvt.metadatasources;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.MetadataSourceElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.MetadataSourceProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateMetadataSourceTest {
    private static final String testCaseName = "CreateMetadataSourceTest";
    private static final int maxPageSize = 100;
    private static final String profileManagerName = "TestProfileManager";
    private static final String profileManagerDisplayName = "ProfileManager displayName";
    private static final String profileManagerDescription = "ProfileManager description";
    private static final String profileManagerTypeDescription = "ProfileManager type";
    private static final String profileManagerVersion = "ProfileManager version";
    private MetadataSourceProperties metadataSourceProperties = new MetadataSourceProperties();

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateMetadataSourceTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateMetadataSourceTest thisTest = new CreateMetadataSourceTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceCode(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceName(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceDescription(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceWiki());
        MetadataSourceClient client = thisTest.getMetadataSourceClient(serverName, serverPlatformRootURL, auditLog);
        String metadataSourceGUID = thisTest.getMetadataSource(userId, client);
        thisTest.addClassifications(userId, client, metadataSourceGUID);
    }

    private CreateMetadataSourceTest() {
        this.metadataSourceProperties.setQualifiedName(profileManagerName);
        this.metadataSourceProperties.setDisplayName(profileManagerDisplayName);
        this.metadataSourceProperties.setDescription(profileManagerDescription);
        this.metadataSourceProperties.setDeployedImplementationType(profileManagerTypeDescription);
        this.metadataSourceProperties.setVersion(profileManagerVersion);
    }

    private MetadataSourceClient getMetadataSourceClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getMetadataSourceClient";
        try {
            CommunityProfileRESTClient restClient = new CommunityProfileRESTClient(serverName, serverPlatformRootURL, auditLog);
            return new MetadataSourceClient(serverName, serverPlatformRootURL, restClient, 100);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getMetadataSourceClient", (Throwable)unexpectedError);
        }
    }

    private String getMetadataSource(String userId, MetadataSourceClient client) throws FVTUnexpectedCondition {
        String activityName = "getMetadataSource";
        try {
            String metadataSourceGUID = client.createMetadataSource(userId, this.metadataSourceProperties);
            if (metadataSourceGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getMetadataSource(no GUID for Create)");
            }
            String retrievedProfileManagerGUID = client.getMetadataSourceGUID(userId, profileManagerName);
            if (retrievedProfileManagerGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getMetadataSource(no GUID for Retrieve)");
            }
            if (!retrievedProfileManagerGUID.equals(metadataSourceGUID)) {
                throw new FVTUnexpectedCondition(testCaseName, "getMetadataSource(Inconsistent GUIDs)");
            }
            return metadataSourceGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getMetadataSource", (Throwable)unexpectedError);
        }
    }

    private void addClassifications(String userId, MetadataSourceClient client, String metadataSourceGUID) throws FVTUnexpectedCondition {
        String activityName = "saveClassifications";
        try {
            MetadataSourceElement metadataSource = client.getMetadataSource(userId, metadataSourceGUID);
            if (metadataSource == null) {
                throw new FVTUnexpectedCondition(testCaseName, "saveClassifications(no metadata source retrieved)");
            }
            ElementHeader header = metadataSource.getElementHeader();
            if (header == null) {
                throw new FVTUnexpectedCondition(testCaseName, "saveClassifications(no header retrieved)");
            }
            this.validateClassifications("Plain metadata source", false, false, false, header.getClassifications());
            client.addUserProfileManagerClassification(userId, metadataSourceGUID);
            metadataSource = client.getMetadataSource(userId, metadataSourceGUID);
            if (metadataSource == null) {
                throw new FVTUnexpectedCondition(testCaseName, "saveClassifications(no metadata source retrieved 2)");
            }
            header = metadataSource.getElementHeader();
            if (header == null) {
                throw new FVTUnexpectedCondition(testCaseName, "saveClassifications(no header retrieved 2)");
            }
            this.validateClassifications("User Profile Manager Added", true, false, false, header.getClassifications());
            client.addUserAccessDirectoryClassification(userId, metadataSourceGUID);
            metadataSource = client.getMetadataSource(userId, metadataSourceGUID);
            if (metadataSource == null) {
                throw new FVTUnexpectedCondition(testCaseName, "saveClassifications(no metadata source retrieved 3)");
            }
            header = metadataSource.getElementHeader();
            if (header == null) {
                throw new FVTUnexpectedCondition(testCaseName, "saveClassifications(no header retrieved 3)");
            }
            this.validateClassifications("User Access Directory Added", true, true, false, header.getClassifications());
            client.addMasterDataManagerClassification(userId, metadataSourceGUID);
            metadataSource = client.getMetadataSource(userId, metadataSourceGUID);
            if (metadataSource == null) {
                throw new FVTUnexpectedCondition(testCaseName, "saveClassifications(no metadata source retrieved 4)");
            }
            header = metadataSource.getElementHeader();
            if (header == null) {
                throw new FVTUnexpectedCondition(testCaseName, "saveClassifications(no header retrieved 4)");
            }
            this.validateClassifications("Master Data Manager Added", true, true, true, header.getClassifications());
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "saveClassifications", (Throwable)unexpectedError);
        }
    }

    private void validateClassifications(String phaseName, boolean userProfileManagerExpected, boolean userAccessDirectoryExpected, boolean masterDataManagerExpected, List<ElementClassification> classifications) throws FVTUnexpectedCondition {
        String activityName = "validateClassifications";
        boolean userProfileManagerSet = false;
        boolean userAccessDirectorySet = false;
        boolean masterDataManagerSet = false;
        if (classifications != null) {
            for (ElementClassification classification : classifications) {
                if (classification == null) continue;
                if ("UserProfileManager".equals(classification.getClassificationName())) {
                    if (!userProfileManagerExpected) {
                        throw new FVTUnexpectedCondition(testCaseName, "validateClassifications:" + phaseName + "(unexpected UserProfileManager) " + classifications.toString());
                    }
                    userProfileManagerSet = true;
                }
                if ("UserAccessDirectory".equals(classification.getClassificationName())) {
                    if (!userAccessDirectoryExpected) {
                        throw new FVTUnexpectedCondition(testCaseName, "validateClassifications:" + phaseName + "(unexpected UserAccessDirectory) " + classifications.toString());
                    }
                    userAccessDirectorySet = true;
                }
                if (!"MasterDataManager".equals(classification.getClassificationName())) continue;
                if (!userAccessDirectoryExpected) {
                    throw new FVTUnexpectedCondition(testCaseName, "validateClassifications:" + phaseName + "(unexpected MasterDataManager) " + classifications.toString());
                }
                masterDataManagerSet = true;
            }
            if (userProfileManagerExpected && !userProfileManagerSet) {
                throw new FVTUnexpectedCondition(testCaseName, "validateClassifications:" + phaseName + "(missing UserProfileManager) " + classifications.toString());
            }
            if (userAccessDirectoryExpected && !userAccessDirectorySet) {
                throw new FVTUnexpectedCondition(testCaseName, "validateClassifications:" + phaseName + "(missing UserAccessDirectory) " + classifications.toString());
            }
            if (masterDataManagerExpected && !masterDataManagerSet) {
                throw new FVTUnexpectedCondition(testCaseName, "validateClassifications:" + phaseName + "(missing MasterDataManager) " + classifications.toString());
            }
        } else {
            if (userProfileManagerExpected) {
                throw new FVTUnexpectedCondition(testCaseName, "validateClassifications:" + phaseName + "(missing UserProfileManager)");
            }
            if (userAccessDirectoryExpected) {
                throw new FVTUnexpectedCondition(testCaseName, "validateClassifications:" + phaseName + "(missing UserAccessDirectory)");
            }
            if (masterDataManagerExpected) {
                throw new FVTUnexpectedCondition(testCaseName, "validateClassifications:" + phaseName + "(missing MasterDataManager)");
            }
        }
    }
}

