/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.OrganizationManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ActorProfileProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.communities.CommunityProperties;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class InvalidParameterTest {
    private static final String testCaseName = "InvalidParameterTest";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            InvalidParameterTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        InvalidParameterTest thisTest = new InvalidParameterTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceCode(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceName(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceDescription(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceWiki());
        thisTest.testOrganizationClient(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testCommunityClient(serverName, serverPlatformRootURL, userId, auditLog);
    }

    private void testCommunityClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testCommunityClient";
        try {
            CommunityProfileRESTClient restClient = new CommunityProfileRESTClient(serverName, serverPlatformRootURL, auditLog);
            CommunityManagement client = new CommunityManagement(serverName, serverPlatformRootURL, restClient, 100);
            this.testSetUpCommunity(client, userId);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCommunityClient", unexpectedError);
        }
    }

    private void testSetUpCommunityNoUserId(CommunityManagement client) throws FVTUnexpectedCondition {
        String activityName = "testSetUpCommunityNoUserId";
        try {
            CommunityProperties properties = new CommunityProperties();
            properties.setQualifiedName("TestQualifiedName");
            client.createCommunity(null, null, null, properties);
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpCommunityNoUserId");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpCommunityNoUserId", unexpectedError);
        }
    }

    private void testSetUpCommunityNoProperties(CommunityManagement client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testSetUpCommunityNoProperties";
        try {
            client.createCommunity(userId, null, null, null);
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpCommunityNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpCommunityNoProperties", unexpectedError);
        }
    }

    private void testSetUpCommunityNoName(CommunityManagement client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testSetUpCommunityNoUserId";
        try {
            client.createCommunity(userId, null, null, new CommunityProperties());
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpCommunityNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpCommunityNoUserId", unexpectedError);
        }
    }

    private void testSetUpCommunity(CommunityManagement client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testSetUpProfileNoName";
        try {
            this.testSetUpCommunityNoUserId(client);
            this.testSetUpCommunityNoProperties(client, userId);
            this.testSetUpCommunityNoName(client, userId);
        }
        catch (FVTUnexpectedCondition fVTUnexpectedCondition) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpProfileNoName", unexpectedError);
        }
    }

    private void testOrganizationClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testOrganizationClient";
        try {
            CommunityProfileRESTClient restClient = new CommunityProfileRESTClient(serverName, serverPlatformRootURL, auditLog);
            OrganizationManagement client = new OrganizationManagement(serverName, serverPlatformRootURL, restClient, 100);
            this.testGetMyProfile(client);
            this.testGetProfileByUserId(client);
            this.testSetUpProfile(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testOrganizationClient", unexpectedError);
        }
    }

    private void testGetMyProfile(OrganizationManagement client) throws FVTUnexpectedCondition {
        String activityName = "testGetMyProfile";
        try {
            this.testGetMyProfileNoUserId(client);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyProfile", unexpectedError);
        }
    }

    private void testGetMyProfileNoUserId(OrganizationManagement client) throws FVTUnexpectedCondition {
        String activityName = "testGetMyProfileNoUserId";
        try {
            client.getActorProfiles(null, 0, 0);
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyProfileNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyProfileNoUserId", unexpectedError);
        }
    }

    private void testGetProfileByUserId(OrganizationManagement client) throws FVTUnexpectedCondition {
        String activityName = "testGetMyKarmaPoints";
        try {
            this.testGetProfileByUserIdNoUserId(client);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetMyKarmaPoints", unexpectedError);
        }
    }

    private void testGetProfileByUserIdNoUserId(OrganizationManagement client) throws FVTUnexpectedCondition {
        String activityName = "testGetProfileByUserIdNoUserId";
        try {
            client.getActorProfileByUserId(null, "testProfileUserId");
            throw new FVTUnexpectedCondition(testCaseName, "testGetProfileByUserIdNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetProfileByUserIdNoUserId", unexpectedError);
        }
    }

    private void testSetUpProfile(String userId, OrganizationManagement client) throws FVTUnexpectedCondition {
        String activityName = "testSetUpProfile";
        try {
            this.testSetUpProfileNoUserId(client);
            this.testSetUpProfileNoProperties(client, userId);
            this.testSetUpProfileNoName(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpProfile", unexpectedError);
        }
    }

    private void testSetUpProfileNoUserId(OrganizationManagement client) throws FVTUnexpectedCondition {
        String activityName = "testSetUpMyProfileNoUserId";
        try {
            ActorProfileProperties properties = new ActorProfileProperties();
            properties.setQualifiedName("TestQualifiedName");
            client.createActorProfile(null, null, null, properties, null);
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpMyProfileNoUserId");
        }
        catch (InvalidParameterException properties) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpMyProfileNoUserId", unexpectedError);
        }
    }

    private void testSetUpProfileNoProperties(OrganizationManagement client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testSetUpProfileNoProperties";
        try {
            client.createActorProfile(userId, null, null, null, null);
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpProfileNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpProfileNoProperties", unexpectedError);
        }
    }

    private void testSetUpProfileNoName(OrganizationManagement client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testSetUpProfileNoName";
        try {
            client.createActorProfile(userId, null, null, new ActorProfileProperties(), null);
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpProfileNoName");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testSetUpProfileNoName", unexpectedError);
        }
    }
}

