/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.builders;

import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalProfileBuilder {
    private static final Logger log = LoggerFactory.getLogger(PersonalProfileBuilder.class);
    private static final String qualifiedNameParameterName = "qualifiedName";
    private static final String nameParameterName = "name";
    private OMRSRepositoryHelper repositoryHelper;
    private String serviceName;

    public PersonalProfileBuilder(String qualifiedName, String fullName, String name, String jobTitle, String jobRoleDescription, Map<String, String> additionalProperties) {
    }

    public PersonalProfileBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    private InstanceProperties getPersonEntityProperties(String qualifiedName, String name, String fullName, String jobTitle, String description, Map<String, String> additionalProperties) {
        String methodName = "getPersonEntityProperties";
        InstanceProperties properties = null;
        if (qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, qualifiedNameParameterName, qualifiedName, "getPersonEntityProperties");
        }
        if (fullName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "fullName", fullName, "getPersonEntityProperties");
        }
        if (name != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, nameParameterName, name, "getPersonEntityProperties");
        }
        if (jobTitle != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "jobTitle", jobTitle, "getPersonEntityProperties");
        }
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, "getPersonEntityProperties");
        }
        if (additionalProperties != null && !additionalProperties.isEmpty()) {
            properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, "additionalProperties", additionalProperties, "getPersonEntityProperties");
        }
        log.debug("Instance properties: " + properties.toString());
        return properties;
    }
}

