/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Classification;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Collection;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CollectionOrder;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(CollectionConverter.class);

    CollectionConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String componentName) {
        super(entity, relationship, repositoryHelper, componentName);
    }

    public Collection getBean() {
        String methodName = "getBean";
        Collection bean = new Collection();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null) {
            List<Classification> classifications;
            InstanceProperties instanceProperties = this.entity.getProperties();
            if (instanceProperties != null) {
                bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
                bean.setName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
                bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
                bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
            if ((classifications = super.getClassificationsFromEntity()) != null) {
                bean.setClassifications(classifications);
                for (Classification classification : classifications) {
                    Map classificationProperties;
                    if (classification == null || !"Folder".equals(classification.getName()) || (classificationProperties = classification.getProperties()) == null) continue;
                    String orderBy = null;
                    String orderPropertyName = null;
                    for (String propertyName : classificationProperties.keySet()) {
                        if ("orderBy".equals(propertyName)) {
                            orderBy = classificationProperties.get(propertyName).toString();
                            continue;
                        }
                        if (!"orderPropertyName".equals(propertyName)) continue;
                        orderPropertyName = classificationProperties.get(propertyName).toString();
                    }
                    this.setUpOrderByProperty(orderBy, orderPropertyName, bean);
                }
            }
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }

    private void setUpOrderByProperty(String orderBy, String orderByPropertyName, Collection bean) {
        if (orderBy != null) {
            if ("Name".equals(orderBy)) {
                bean.setCollectionOrdering(CollectionOrder.NAME);
            } else if ("Owner".equals(orderBy)) {
                bean.setCollectionOrdering(CollectionOrder.OWNER);
            } else if ("DateAdded".equals(orderBy)) {
                bean.setCollectionOrdering(CollectionOrder.DATE_ADDED);
            } else if ("DateUpdated".equals(orderBy)) {
                bean.setCollectionOrdering(CollectionOrder.DATE_UPDATED);
            } else if ("DateCreated".equals(orderBy)) {
                bean.setCollectionOrdering(CollectionOrder.DATE_CREATED);
            } else if ("Other".equals(orderBy)) {
                if ("qualifiedName".equals(orderByPropertyName)) {
                    bean.setCollectionOrdering(CollectionOrder.QUALIFIED_NAME);
                } else {
                    bean.setCollectionOrdering(CollectionOrder.TYPE_NAME);
                }
            }
        }
        log.debug("OrderBy: " + bean.getCollectionOrdering());
    }
}

