/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommunityMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommunityMembershipType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityMemberConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(CommunityMemberConverter.class);

    CommunityMemberConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String componentName) {
        super(entity, relationship, repositoryHelper, componentName);
    }

    public CommunityMember getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        CommunityMember bean = new CommunityMember();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
            bean.setName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
            bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        }
        if (this.relationship != null) {
            bean.setCommunityGUID(this.repositoryHelper.getEnd1EntityGUID(this.relationship));
            instanceProperties = this.relationship.getProperties();
            if (instanceProperties != null) {
                bean.setMembershipType(this.getMembershipTypeFromProperties(instanceProperties));
            }
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }

    private CommunityMembershipType getMembershipTypeFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        CommunityMembershipType contactMethodType = CommunityMembershipType.OTHER;
        if (properties != null && (instancePropertyValue = properties.getPropertyValue("membershipType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    contactMethodType = CommunityMembershipType.CONTRIBUTOR;
                    break;
                }
                case 1: {
                    contactMethodType = CommunityMembershipType.ADMINISTRATOR;
                    break;
                }
                case 2: {
                    contactMethodType = CommunityMembershipType.LEADER;
                    break;
                }
                case 3: {
                    contactMethodType = CommunityMembershipType.OBSERVER;
                    break;
                }
                case 99: {
                    contactMethodType = CommunityMembershipType.OTHER;
                }
            }
        }
        log.debug("ContactMethodType: " + contactMethodType.getName());
        return contactMethodType;
    }
}

