/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonRole;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonRoleConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(PersonRoleConverter.class);
    private List<Relationship> personRoleRelationships;

    PersonRoleConverter(EntityDetail entity, List<Relationship> relationships, OMRSRepositoryHelper repositoryHelper, String componentName) {
        super(entity, repositoryHelper, componentName);
        this.personRoleRelationships = relationships;
    }

    public PersonRole getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        PersonRole bean = new PersonRole();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
            bean.setName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
            bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
            if (instanceProperties.getPropertyValue("headCount") != null) {
                bean.setHeadCountLimitSet(true);
                bean.setHeadCount(this.repositoryHelper.removeIntProperty(this.serviceName, "headCount", instanceProperties, "getBean"));
            }
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            bean.setClassifications(super.getClassificationsFromEntity());
        }
        if (this.personRoleRelationships != null) {
            int appointeeCount = 0;
            for (Relationship relationship : this.personRoleRelationships) {
                InstanceType instanceType;
                if (relationship == null || (instanceType = relationship.getType()) == null || !"PersonRoleAppointment".equals(instanceType.getTypeDefName())) continue;
                ++appointeeCount;
            }
            bean.setAppointmentCount(appointeeCount);
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }
}

