/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethod;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserIdentity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalProfileConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(PersonalProfileConverter.class);
    private EntityDetail contributionEntity;
    private List<UserIdentity> associatedUserIds;
    private List<ContactMethod> contactDetails;

    PersonalProfileConverter(EntityDetail personEntity, EntityDetail contributionEntity, List<UserIdentity> associatedUserIds, List<ContactMethod> contactDetails, OMRSRepositoryHelper repositoryHelper, String componentName) {
        super(personEntity, repositoryHelper, componentName);
        this.contributionEntity = contributionEntity;
        this.associatedUserIds = associatedUserIds;
        this.contactDetails = contactDetails;
    }

    public PersonalProfile getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        PersonalProfile bean = new PersonalProfile();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
            bean.setName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
            bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
            bean.setFullName(this.repositoryHelper.removeStringProperty(this.serviceName, "fullName", instanceProperties, "getBean"));
            bean.setJobTitle(this.repositoryHelper.removeStringProperty(this.serviceName, "jobTitle", instanceProperties, "getBean"));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            bean.setClassifications(super.getClassificationsFromEntity());
        }
        if (this.contributionEntity != null && (instanceProperties = this.contributionEntity.getProperties()) != null) {
            bean.setKarmaPoints(this.repositoryHelper.getIntProperty(this.serviceName, "karmaPoints", instanceProperties, "getBean"));
        }
        bean.setAssociatedUserIds(this.associatedUserIds);
        bean.setContactDetails(this.contactDetails);
        log.debug("Bean: " + bean.toString());
        return bean;
    }
}

