/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Team;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(TeamConverter.class);
    private List<Relationship> teamRelationships;

    TeamConverter(EntityDetail entity, List<Relationship> relationships, OMRSRepositoryHelper repositoryHelper, String componentName) {
        super(entity, repositoryHelper, componentName);
        this.teamRelationships = relationships;
    }

    public Team getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        Team bean = new Team();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
            bean.setName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
            bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
            bean.setTeamType(this.repositoryHelper.removeStringProperty(this.serviceName, "teamType", instanceProperties, "getBean"));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            bean.setClassifications(super.getClassificationsFromEntity());
        }
        if (this.teamRelationships != null) {
            ArrayList<String> subTeamList = new ArrayList<String>();
            String myGUID = this.entity.getGUID();
            if (myGUID != null) {
                for (Relationship relationship : this.teamRelationships) {
                    InstanceType instanceType;
                    if (relationship == null || (instanceType = relationship.getType()) == null || !"TeamStructure".equals(instanceType.getTypeDefName())) continue;
                    String superTeamGUID = this.repositoryHelper.getEnd1EntityGUID(relationship);
                    String subTeamGUID = this.repositoryHelper.getEnd2EntityGUID(relationship);
                    if (myGUID.equals(superTeamGUID)) {
                        subTeamList.add(subTeamGUID);
                        continue;
                    }
                    if (!myGUID.equals(subTeamGUID)) continue;
                    bean.setSuperTeam(superTeamGUID);
                }
            }
            if (!subTeamList.isEmpty()) {
                bean.setSubTeams(subTeamList);
            }
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }
}

