/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ToDo;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ToDoStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToDoConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(ToDoConverter.class);

    ToDoConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String componentName) {
        super(entity, repositoryHelper, componentName);
    }

    public ToDo getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        ToDo bean = new ToDo();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
            bean.setName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
            bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
            bean.setCompletionTime(this.repositoryHelper.removeDateProperty(this.serviceName, "creationTime", instanceProperties, "getBean"));
            bean.setPriority(this.repositoryHelper.removeIntProperty(this.serviceName, "priority", instanceProperties, "getBean"));
            bean.setDueTime(this.repositoryHelper.removeDateProperty(this.serviceName, "dueTime", instanceProperties, "getBean"));
            bean.setCompletionTime(this.repositoryHelper.removeDateProperty(this.serviceName, "completionTime", instanceProperties, "getBean"));
            bean.setStatus(this.getToDoStatusFromProperties(instanceProperties));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            bean.setClassifications(super.getClassificationsFromEntity());
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }

    private ToDoStatus getToDoStatusFromProperties(InstanceProperties properties) {
        ToDoStatus toDoStatus = ToDoStatus.ABANDONED;
        if (properties != null) {
            InstancePropertyValue instancePropertyValue = properties.getPropertyValue("status");
            if (instancePropertyValue instanceof EnumPropertyValue) {
                EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
                switch (enumPropertyValue.getOrdinal()) {
                    case 0: {
                        toDoStatus = ToDoStatus.OPEN;
                        break;
                    }
                    case 1: {
                        toDoStatus = ToDoStatus.IN_PROGRESS;
                        break;
                    }
                    case 2: {
                        toDoStatus = ToDoStatus.WAITING;
                        break;
                    }
                    case 3: {
                        toDoStatus = ToDoStatus.COMPLETE;
                        break;
                    }
                    case 99: {
                        toDoStatus = ToDoStatus.ABANDONED;
                    }
                }
            }
            Map instancePropertyValueMap = properties.getInstanceProperties();
            instancePropertyValueMap.remove("status");
            properties.setInstanceProperties(instancePropertyValueMap);
        }
        log.debug("ToDoStatus: " + toDoStatus.getName());
        return toDoStatus;
    }
}

