/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.outtopic;

import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityProfilePublisher {
    private static final String personalProfileTypeName = "PersonalProfile";
    private static final Logger log = LoggerFactory.getLogger(CommunityProfilePublisher.class);
    private Connection communityProfileOutTopic;
    private OMRSRepositoryHelper repositoryHelper;
    private OMRSRepositoryValidator repositoryValidator;
    private String serviceName;

    public CommunityProfilePublisher(Connection communityProfileOutTopic, OMRSRepositoryConnector repositoryConnector, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String serviceName) {
        this.communityProfileOutTopic = communityProfileOutTopic;
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.serviceName = serviceName;
    }

    public void processNewEntity(EntityDetail entity) {
        String personalProfileType = this.getPersonalProfileType(entity);
        if (personalProfileType != null) {
            this.processNewPersonalProfile(this.getPersonalProfile(entity));
        }
    }

    public void processUpdatedEntity(EntityDetail entity) {
        String personalProfileType = this.getPersonalProfileType(entity);
        if (personalProfileType != null) {
            this.processUpdatedPersonalProfile(this.getPersonalProfile(entity));
        }
    }

    public void processUpdatedEntity(EntityDetail originalEntity, EntityDetail newEntity) {
        String personalProfileType = this.getPersonalProfileType(newEntity);
        if (personalProfileType != null) {
            this.processUpdatedPersonalProfile(this.getPersonalProfile(originalEntity), this.getPersonalProfile(newEntity));
        }
    }

    public void processDeletedEntity(EntityDetail entity) {
        String personalProfileType = this.getPersonalProfileType(entity);
        if (personalProfileType != null) {
            this.processDeletedPersonalProfile(this.getPersonalProfile(entity));
        }
    }

    public void processRestoredEntity(EntityDetail entity) {
        String personalProfileType = this.getPersonalProfileType(entity);
        if (personalProfileType != null) {
            this.processRestoredPersonalProfile(this.getPersonalProfile(entity));
        }
    }

    public void processNewRelationship(Relationship relationship) {
    }

    public void processUpdatedRelationship(Relationship relationship) {
    }

    public void processUpdatedRelationship(Relationship originalRelationship, Relationship newRelationship) {
    }

    public void processDeletedRelationship(Relationship relationship) {
    }

    public void processRestoredRelationship(Relationship relationship) {
    }

    private String getPersonalProfileType(EntityDetail entity) {
        InstanceType entityType;
        String methodName = "getPersonalProfileType";
        if (this.repositoryValidator.isATypeOf(this.serviceName, (InstanceAuditHeader)entity, personalProfileTypeName, "getPersonalProfileType") && (entityType = entity.getType()) != null) {
            return entityType.getTypeDefName();
        }
        return null;
    }

    private PersonalProfile getPersonalProfile(EntityDetail entity) {
        return null;
    }

    private void processNewPersonalProfile(PersonalProfile personalProfile) {
        log.info("Community Profile Event => New PersonalProfile: " + personalProfile.toString());
    }

    private void processUpdatedPersonalProfile(PersonalProfile personalProfile) {
        log.info("Community Profile Event => Updated PersonalProfile: " + personalProfile.toString());
    }

    private void processUpdatedPersonalProfile(PersonalProfile originalPersonalProfile, PersonalProfile newPersonalProfile) {
        log.info("Community Profile Event => Original PersonalProfile: " + originalPersonalProfile.toString());
        log.info("Community Profile Event => Updated PersonalProfile: " + newPersonalProfile.toString());
    }

    private void processDeletedPersonalProfile(PersonalProfile personalProfile) {
        log.info("Community Profile Event => Deleted PersonalProfile: " + personalProfile.toString());
    }

    private void processRestoredPersonalProfile(PersonalProfile personalProfile) {
        log.info("Community Profile Event => Restored PersonalProfile: " + personalProfile.toString());
    }
}

