/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileRegistration;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileServicesInstance;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileServicesInstanceMap;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class CommunityProfileInstanceHandler {
    private static CommunityProfileServicesInstanceMap instanceMap = new CommunityProfileServicesInstanceMap();
    private static AccessServiceDescription myDescription = AccessServiceDescription.COMMUNITY_PROFILE_OMAS;

    CommunityProfileInstanceHandler() {
        CommunityProfileRegistration.registerAccessService();
    }

    OMRSMetadataCollection getMetadataCollection(String serverName) throws PropertyServerException {
        CommunityProfileServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getMetadataCollection();
        }
        String methodName = "getMetadataCollection";
        CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getMetadataCollection"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public String getAccessServiceName() {
        return myDescription.getAccessServiceName();
    }

    OMRSRepositoryConnector getRepositoryConnector(String serverName) throws PropertyServerException {
        CommunityProfileServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getRepositoryConnector();
        }
        String methodName = "getRepositoryConnector";
        CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getRepositoryConnector"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

