/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileServicesInstanceMap;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class CommunityProfileServicesInstance {
    private OMRSRepositoryConnector repositoryConnector = null;
    private OMRSMetadataCollection metadataCollection = null;
    private String serverName = null;

    public CommunityProfileServicesInstance(OMRSRepositoryConnector repositoryConnector) throws NewInstanceException {
        String methodName = "new ServiceInstance";
        if (repositoryConnector != null) {
            try {
                this.repositoryConnector = repositoryConnector;
                this.serverName = repositoryConnector.getServerName();
                this.metadataCollection = repositoryConnector.getMetadataCollection();
                CommunityProfileServicesInstanceMap.setNewInstanceForJVM(this.serverName, this);
            }
            catch (Throwable error) {
                CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.OMRS_NOT_INITIALIZED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
                throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getServerName"});
        throw new NewInstanceException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getServerName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public OMRSMetadataCollection getMetadataCollection() throws PropertyServerException {
        String methodName = "getMetadataCollection";
        if (this.repositoryConnector != null && this.metadataCollection != null && this.repositoryConnector.isActive()) {
            return this.metadataCollection;
        }
        CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getMetadataCollection"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public OMRSRepositoryConnector getRepositoryConnector() throws PropertyServerException {
        String methodName = "getRepositoryConnector";
        if (this.repositoryConnector != null && this.metadataCollection != null && this.repositoryConnector.isActive()) {
            return this.repositoryConnector;
        }
        CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.OMRS_NOT_AVAILABLE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getRepositoryConnector"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void shutdown() {
        CommunityProfileServicesInstanceMap.removeInstanceForJVM(this.serverName);
    }
}

