/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class ErrorHandler {
    private final String defaultGUIDParameterName = "guid";
    private OMRSRepositoryConnector repositoryConnector;

    ErrorHandler(OMRSRepositoryConnector repositoryConnector) {
        this.repositoryConnector = repositoryConnector;
    }

    void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (userId == null) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "userId");
        }
    }

    void validateGUID(String guid, String parameterName, String methodName) throws InvalidParameterException {
        if (guid == null) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validateGUID(String guid, String parameterName, String expectedTypeName, String methodName) throws InvalidParameterException {
        if (guid == null) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{expectedTypeName, parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validateEnum(Object enumValue, String parameterName, String methodName) throws InvalidParameterException {
        if (enumValue == null) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NULL_ENUM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validateName(String name, String parameterName, String methodName) throws InvalidParameterException {
        if (name == null) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validateText(String text, String parameterName, String methodName) throws InvalidParameterException {
        if (text == null) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NULL_TEXT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "text");
        }
    }

    void validatePaging(int startFrom, int pageSize, String methodName) throws InvalidParameterException {
        String startFromParameterName = "startFrom";
        String pageSizeParameterName = "pageSize";
        if (startFrom < 0) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NEGATIVE_START_FROM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"startFrom", methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "startFrom");
        }
        if (pageSize < 1) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NEGATIVE_PAGE_SIZE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"pageSize", methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "pageSize");
        }
    }

    void handleWrongTypeForGUIDException(String guid, String methodName, String actualType, String expectedType) throws InvalidParameterException {
        CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.INSTANCE_WRONG_TYPE_FOR_GUID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, guid, actualType, expectedType});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "guid");
    }

    OMRSMetadataCollection validateRepositoryConnector(String methodName) throws PropertyServerException {
        if (this.repositoryConnector == null) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!this.repositoryConnector.isActive()) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.OMRS_NOT_AVAILABLE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            return this.repositoryConnector.getMetadataCollection();
        }
        catch (Throwable error) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NO_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void handleUnauthorizedUser(String userId, String methodName, String serverName, String serviceName) throws UserNotAuthorizedException {
        CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.USER_NOT_AUTHORIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, methodName, serviceName, serverName});
        throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), userId);
    }

    void handleRepositoryError(Throwable error, String methodName, String serverName, String serviceName) throws PropertyServerException {
        CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.PROPERTY_SERVER_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getMessage(), methodName, serviceName, serverName});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    void handleUnrecognizedGUIDException(String userId, String methodName, String serverName, String expectedType, String guid) throws InvalidParameterException {
        CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.INSTANCE_NOT_FOUND_BY_GUID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, expectedType, guid, userId, serverName});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "guid");
    }
}

