/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.ExternalReferenceManagementInterface;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ExternalReference;
import org.odpi.openmetadata.accessservices.communityprofile.server.ErrorHandler;
import org.odpi.openmetadata.accessservices.communityprofile.server.RepositoryHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalReferencesHandler
implements ExternalReferenceManagementInterface {
    private static final String externalReferenceTypeGUID = "af536f20-062b-48ef-9c31-1ddd05b04c56";
    private static final String externalReferenceTypeName = "ExternalReference";
    private static final String externalReferenceIdPropertyName = "qualifiedName";
    private static final String displayNamePropertyName = "displayName";
    private static final String uriPropertyName = "url";
    private static final String versionPropertyName = "version";
    private static final String resourceDescriptionPropertyName = "description";
    private static final String organizationPropertyName = "organization";
    private static final String additionalPropertiesName = "additionalProperties";
    private static final String externalReferenceLinkTypeGUID = "7d818a67-ab45-481c-bc28-f6b1caf12f06";
    private static final String externalReferenceLinkTypeName = "ExternalReferenceLink";
    private static final String localReferenceIdPropertyName = "referenceId";
    private static final String linkDescriptionPropertyName = "description";
    private static final Logger log = LoggerFactory.getLogger(ExternalReferencesHandler.class);
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private ErrorHandler errorHandler = null;
    private RepositoryHandler basicHandler = null;

    ExternalReferencesHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new ErrorHandler(repositoryConnector);
            this.basicHandler = new RepositoryHandler(serviceName, repositoryConnector);
        }
    }

    public List<ExternalReference> findExternalReferencesById(String userId, String resourceId, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findExternalReferencesById";
        return null;
    }

    public List<ExternalReference> findExternalReferencesByURL(String userId, String url, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findExternalReferencesByURL";
        return null;
    }

    public ExternalReference getExternalReference(String userId, String externalReferenceGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getExternalReference";
        return null;
    }

    public List<ExternalReference> retrieveAttachedExternalReferences(String userId, String attachedToGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveAttachedExternalReferences";
        log.warn("retrieveAttachedExternalReferences not implemented");
        return null;
    }

    public void linkExternalReference(String userId, String attachedToGUID, String linkId, String linkDescription, String externalReferenceGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReference";
    }

    public void unlinkExternalReference(String userId, String attachedToGUID, String externalReferenceGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "unlinkExternalReference";
    }

    public String storeExternalReference(String userId, String attachedToGUID, String linkId, String linkDescription, String resourceId, String resourceDisplayName, String resourceDescription, String resourceURL, String resourceVersion, String owningOrganization, Map<String, Object> resourceProperties, Map<String, String> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "storeExternalReferences";
        String guidParameterName = "attachedToGUID";
        String expectedType = "Referenceable";
        EntityDetail anchorEntity = this.basicHandler.getEntityByGUID(attachedToGUID, "attachedToGUID", userId, "storeExternalReferences", "Referenceable");
        if (anchorEntity != null) {
            // empty if block
        }
        log.warn("storeExternalReferences not implemented");
        return null;
    }

    public void deleteExternalReference(String userId, String externalReferenceGUID, String externalReferenceId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReference";
    }
}

