/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.CommunityProfileCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.communityprofile.rest.AssetListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.CommunityProfileOMASAPIResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MyProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.NullRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.accessservices.communityprofile.server.MyProfileHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyProfileRESTServices {
    private static CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(MyProfileRESTServices.class);

    public PersonalProfileResponse getMyProfile(String serverName, String userId) {
        String methodName = "getMyProfile";
        log.debug("Calling method: getMyProfile");
        PersonalProfileResponse response = new PersonalProfileResponse();
        try {
            MyProfileHandler handler = new MyProfileHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            response.setPersonalProfile(handler.getMyProfile(userId));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((CommunityProfileOMASAPIResponse)response, error);
        }
        catch (NoProfileForUserException error) {
            this.captureNoProfileForUserException((CommunityProfileOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((CommunityProfileOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((CommunityProfileOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getMyProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse updateMyProfile(String serverName, String userId, MyProfileRequestBody requestBody) {
        String methodName = "updateMyProfile";
        log.debug("Calling method: updateMyProfile");
        VoidResponse response = new VoidResponse();
        try {
            String employeeNumber = null;
            String fullName = null;
            String knownName = null;
            String jobTitle = null;
            String jobRoleDescription = null;
            Map profileProperties = null;
            Map additionalProperties = null;
            if (requestBody != null) {
                employeeNumber = requestBody.getQualifiedName();
                fullName = requestBody.getFullName();
                knownName = requestBody.getKnownName();
                jobTitle = requestBody.getJobTitle();
                jobRoleDescription = requestBody.getJobRoleDescription();
                profileProperties = requestBody.getProfileProperties();
                additionalProperties = requestBody.getAdditionalProperties();
            }
            MyProfileHandler handler = new MyProfileHandler(instanceHandler.getAccessServiceName(), instanceHandler.getRepositoryConnector(serverName));
            handler.updateMyProfile(userId, employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, profileProperties, additionalProperties);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((CommunityProfileOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((CommunityProfileOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((CommunityProfileOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: updateMyProfile with response: " + response.toString());
        return response;
    }

    public AssetListResponse getMyAssets(String serverName, String userId, int startFrom, int pageSize) {
        return null;
    }

    public VoidResponse addToMyAssets(String serverName, String userId, String assetGUID, NullRequestBody nullRequestBody) {
        return null;
    }

    public VoidResponse removeFromMyAssets(String serverName, String userId, String assetGUID, NullRequestBody nullRequestBody) {
        return null;
    }

    private void captureCheckedException(CommunityProfileOMASAPIResponse response, CommunityProfileCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private void captureCheckedException(CommunityProfileOMASAPIResponse response, CommunityProfileCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(exceptionProperties);
    }

    private void captureInvalidParameterException(CommunityProfileOMASAPIResponse response, InvalidParameterException error) {
        String parameterName = error.getParameterName();
        if (parameterName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", parameterName);
            this.captureCheckedException(response, (CommunityProfileCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (CommunityProfileCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void capturePropertyServerException(CommunityProfileOMASAPIResponse response, PropertyServerException error) {
        this.captureCheckedException(response, (CommunityProfileCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureUserNotAuthorizedException(CommunityProfileOMASAPIResponse response, UserNotAuthorizedException error) {
        String userId = error.getUserId();
        if (userId != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("userId", userId);
            this.captureCheckedException(response, (CommunityProfileCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (CommunityProfileCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureNoProfileForUserException(CommunityProfileOMASAPIResponse response, NoProfileForUserException error) {
        String userId = error.getUserId();
        if (userId != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("userId", userId);
            this.captureCheckedException(response, (CommunityProfileCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (CommunityProfileCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }
}

