/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Review;
import org.odpi.openmetadata.accessservices.communityprofile.properties.StarRating;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(ReviewConverter.class);

    public ReviewConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, relationship, repositoryHelper, serviceName);
    }

    public Review getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        Review bean = new Review();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setReview(this.repositoryHelper.removeStringProperty(this.serviceName, "review", instanceProperties, "getBean"));
            bean.setStars(this.getStarRatingFromProperties(instanceProperties));
        }
        if (this.relationship != null) {
            bean.setUserId(this.relationship.getCreatedBy());
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }

    private StarRating getStarRatingFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        StarRating rating = null;
        if (properties != null && (instancePropertyValue = properties.getPropertyValue("stars")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    rating = StarRating.NOT_RECOMMENDED;
                    break;
                }
                case 1: {
                    rating = StarRating.ONE_STAR;
                    break;
                }
                case 2: {
                    rating = StarRating.TWO_STARS;
                    break;
                }
                case 3: {
                    rating = StarRating.THREE_STARS;
                    break;
                }
                case 4: {
                    rating = StarRating.FOUR_STARS;
                    break;
                }
                case 5: {
                    rating = StarRating.FIVE_STARS;
                }
            }
        }
        log.debug("StarRating: " + rating.getName());
        return rating;
    }
}

