/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.AssetCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.OwnerType;
import org.odpi.openmetadata.accessservices.communityprofile.properties.WatchStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetCollectionMemberConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(AssetCollectionMemberConverter.class);

    public AssetCollectionMemberConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, relationship, repositoryHelper, serviceName);
    }

    public AssetCollectionMember getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        AssetCollectionMember bean = new AssetCollectionMember();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
            bean.setName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
            bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
            bean.setOwner(this.repositoryHelper.removeStringProperty(this.serviceName, "owner", instanceProperties, "getBean"));
            bean.setOwnerType(this.getOwnerTypeFromProperties(instanceProperties));
            bean.setDateAssetCreated(this.entity.getCreateTime());
            bean.setDateAssetLastUpdated(this.entity.getUpdateTime());
            bean.setLastChange(this.repositoryHelper.removeStringProperty(this.serviceName, "latestChange", instanceProperties, "getBean"));
            bean.setZoneMembership(this.repositoryHelper.removeStringArrayProperty(this.serviceName, "zoneMembership", instanceProperties, "getBean"));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        }
        if (this.relationship != null) {
            bean.setDateAddedToCollection(this.relationship.getCreateTime());
            instanceProperties = this.relationship.getProperties();
            if (instanceProperties != null) {
                bean.setMembershipRationale(this.repositoryHelper.getStringProperty(this.serviceName, "resourceUse", instanceProperties, "getBean"));
                if (instanceProperties.getPropertyValue("watchResource") != null) {
                    if (this.repositoryHelper.getBooleanProperty(this.serviceName, "watchResource", instanceProperties, "getBean")) {
                        bean.setWatchStatus(WatchStatus.WATCHED);
                    } else {
                        bean.setWatchStatus(WatchStatus.NOT_WATCHED);
                    }
                } else {
                    bean.setWatchStatus(WatchStatus.USE_DEFAULT);
                }
            }
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }

    private OwnerType getOwnerTypeFromProperties(InstanceProperties properties) {
        OwnerType ownerType = null;
        if (properties != null) {
            InstancePropertyValue instancePropertyValue = properties.getPropertyValue("ownerType");
            if (instancePropertyValue instanceof EnumPropertyValue) {
                EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
                switch (enumPropertyValue.getOrdinal()) {
                    case 0: {
                        ownerType = OwnerType.USER_ID;
                        break;
                    }
                    case 1: {
                        ownerType = OwnerType.PROFILE_ID;
                        break;
                    }
                    case 99: {
                        ownerType = OwnerType.OTHER;
                    }
                }
            }
            Map instancePropertyValueMap = properties.getInstanceProperties();
            instancePropertyValueMap.remove("ownerType");
            properties.setInstanceProperties(instancePropertyValueMap);
        }
        log.debug("OwnerType: " + ownerType.getName());
        return ownerType;
    }
}

