/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalProfileBuilder
extends ReferenceableBuilder {
    private static final Logger log = LoggerFactory.getLogger(PersonalProfileBuilder.class);

    public PersonalProfileBuilder(String qualifiedName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName);
    }

    public InstanceProperties getPersonEntityProperties(String name, String fullName, String jobTitle, String description, Map<String, Object> extendedProperties, Map<String, String> additionalProperties) throws InvalidParameterException {
        String methodName = "getPersonEntityProperties";
        InstanceProperties properties = super.getQualifiedNameInstanceProperties("getPersonEntityProperties");
        if (fullName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "fullName", fullName, "getPersonEntityProperties");
        }
        if (name != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", name, "getPersonEntityProperties");
        }
        if (jobTitle != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "jobTitle", jobTitle, "getPersonEntityProperties");
        }
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", description, "getPersonEntityProperties");
        }
        if (extendedProperties != null) {
            try {
                properties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, extendedProperties, "getPersonEntityProperties");
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException error) {
                String propertyName = "extendedProperties";
                this.errorHandler.handleUnsupportedProperty((Throwable)error, "getPersonEntityProperties", "extendedProperties");
            }
        }
        if (additionalProperties != null && !additionalProperties.isEmpty()) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", additionalProperties, "getPersonEntityProperties");
        }
        log.debug("Instance properties: " + properties.toString());
        return properties;
    }
}

