/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Comment;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(CommentConverter.class);
    private List<Relationship> acceptedAnswersRelationships;

    public CommentConverter(EntityDetail entity, Relationship attachedCommentRelationship, List<Relationship> acceptedAnswersRelationships, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, attachedCommentRelationship, repositoryHelper, serviceName);
        this.acceptedAnswersRelationships = acceptedAnswersRelationships;
    }

    public Comment getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        Comment bean = new Comment();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
            bean.setText(this.repositoryHelper.removeStringProperty(this.serviceName, "text", instanceProperties, "getBean"));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        }
        if (this.relationship != null) {
            bean.setUserId(this.relationship.getCreatedBy());
        }
        if (this.acceptedAnswersRelationships != null) {
            ArrayList<String> answeredBy = new ArrayList<String>();
            ArrayList<String> answers = new ArrayList<String>();
            String myGUID = this.entity.getGUID();
            if (myGUID != null) {
                for (Relationship relationship : this.acceptedAnswersRelationships) {
                    InstanceType instanceType;
                    if (relationship == null || (instanceType = relationship.getType()) == null) continue;
                    String answeredQuestionGUID = this.repositoryHelper.getEnd1EntityGUID(relationship);
                    String acceptedAnswerGUID = this.repositoryHelper.getEnd2EntityGUID(relationship);
                    if (myGUID.equals(answeredQuestionGUID)) {
                        answeredBy.add(acceptedAnswerGUID);
                        continue;
                    }
                    if (!myGUID.equals(acceptedAnswerGUID)) continue;
                    answers.add(answeredQuestionGUID);
                }
            }
            if (!answeredBy.isEmpty()) {
                bean.setAnsweredBy(answeredBy);
            }
            if (!answers.isEmpty()) {
                bean.setAnswers(answers);
            }
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }
}

