/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ProjectCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.WatchStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCollectionMemberConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(ProjectCollectionMemberConverter.class);

    public ProjectCollectionMemberConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, relationship, repositoryHelper, serviceName);
    }

    public ProjectCollectionMember getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        ProjectCollectionMember bean = new ProjectCollectionMember();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
            bean.setName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
            bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
            bean.setStartDate(this.repositoryHelper.removeDateProperty(this.serviceName, "startDate", instanceProperties, "getBean"));
            bean.setPlannedEndDate(this.repositoryHelper.removeDateProperty(this.serviceName, "plannedEndDate", instanceProperties, "getBean"));
            bean.setStatus(this.repositoryHelper.removeStringProperty(this.serviceName, "status", instanceProperties, "getBean"));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        }
        if (this.relationship != null) {
            bean.setDateAddedToCollection(this.relationship.getCreateTime());
            instanceProperties = this.relationship.getProperties();
            if (instanceProperties != null) {
                bean.setMembershipRationale(this.repositoryHelper.getStringProperty(this.serviceName, "resourceUse", instanceProperties, "getBean"));
                if (instanceProperties.getPropertyValue("watchResource") != null) {
                    if (this.repositoryHelper.getBooleanProperty(this.serviceName, "watchResource", instanceProperties, "getBean")) {
                        bean.setWatchStatus(WatchStatus.WATCHED);
                    } else {
                        bean.setWatchStatus(WatchStatus.NOT_WATCHED);
                    }
                } else {
                    bean.setWatchStatus(WatchStatus.USE_DEFAULT);
                }
            }
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }
}

