/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.builders.UserIdentityBuilder;
import org.odpi.openmetadata.accessservices.communityprofile.converters.UserIdentityConverter;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserIdentity;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserIdentityHandler {
    private String serviceName;
    private RepositoryErrorHandler errorHandler;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private static final Logger log = LoggerFactory.getLogger(UserIdentityHandler.class);

    public UserIdentityHandler(String serviceName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, RepositoryErrorHandler errorHandler) {
        this.serviceName = serviceName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.errorHandler = errorHandler;
        this.repositoryHandler = repositoryHandler;
    }

    public UserIdentity getUserIdentity(EntityDetail userIdentityEntity) {
        UserIdentityConverter converter = new UserIdentityConverter(userIdentityEntity, this.repositoryHelper, this.serviceName);
        return converter.getBean();
    }

    String getUserIdentityGUID(String userId, String userIdentityQualifiedName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "userIdentityQualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(userIdentityQualifiedName, "userIdentityQualifiedName", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", userId, methodName);
        try {
            EntityDetail userEntity = this.repositoryHandler.getUniqueEntityByName(userId, userIdentityQualifiedName, "userIdentityQualifiedName", properties, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", methodName);
            if (userEntity == null) {
                return this.addUserIdentity(userId, userIdentityQualifiedName, methodName);
            }
            return userEntity.getGUID();
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
            log.debug("Unreachable statement for: " + userId);
            return null;
        }
    }

    public String addUserIdentity(String userId, String profileUserId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "profileUserId";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(profileUserId, "profileUserId", methodName);
        UserIdentityBuilder builder = new UserIdentityBuilder(profileUserId, this.repositoryHelper, this.serviceName);
        InstanceProperties properties = builder.getEntityProperties();
        try {
            String userIdentityGUID = this.repositoryHandler.createEntity(userId, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", properties, methodName);
            if (userIdentityGUID != null) {
                return userIdentityGUID;
            }
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.UNABLE_TO_CREATE_USER_IDENTITY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        catch (PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName);
            log.debug("Unreachable statement for: " + userId);
            return null;
        }
    }

    public void addIdentityToProfile(String userId, String profileGUID, String newIdentity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "newIdentity";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(newIdentity, "newIdentity", methodName);
        String userIdentityGUID = this.getUserIdentityGUID(userId, newIdentity, methodName);
        if (userIdentityGUID == null) {
            userIdentityGUID = this.addUserIdentity(userId, newIdentity, methodName);
        }
        this.repositoryHandler.createRelationship(userId, "01664609-e777-4079-b543-6baffe910ff1", profileGUID, userIdentityGUID, null, methodName);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeIdentityFromProfile(String userId, String profileGUID, String obsoleteIdentity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String errorMessage;
        CommunityProfileErrorCode errorCode;
        String nameParameter = "obsoleteIdentity";
        String guidParameter = "profileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", methodName);
        this.invalidParameterHandler.validateName(obsoleteIdentity, "obsoleteIdentity", methodName);
        List<UserIdentity> associatedUserIds = this.getAssociatedUserIds(userId, profileGUID, methodName);
        if (associatedUserIds == null) {
            CommunityProfileErrorCode errorCode2 = CommunityProfileErrorCode.NO_IDENTITY_FOR_PROFILE;
            String errorMessage2 = errorCode2.getErrorMessageId() + errorCode2.getFormattedErrorMessage(new String[]{profileGUID});
            throw new PropertyServerException(errorCode2.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage2, errorCode2.getSystemAction(), errorCode2.getUserAction());
        }
        String userIdentityGUID = null;
        boolean anotherIdentity = false;
        for (UserIdentity userIdentity : associatedUserIds) {
            if (userIdentity == null) continue;
            if (obsoleteIdentity.equals(userIdentity.getUserId())) {
                userIdentityGUID = userIdentity.getGUID();
                continue;
            }
            anotherIdentity = true;
        }
        if (userIdentityGUID == null) {
            errorCode = CommunityProfileErrorCode.UNKNOWN_IDENTITY;
            errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{obsoleteIdentity, profileGUID});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "obsoleteIdentity");
        }
        if (anotherIdentity) {
            this.repositoryHandler.removeRelationshipBetweenEntities(userId, "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", profileGUID, "Person", userIdentityGUID, methodName);
            return;
        }
        errorCode = CommunityProfileErrorCode.NO_OTHER_IDENTITY;
        errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{obsoleteIdentity, profileGUID});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "obsoleteIdentity");
    }

    public void removeUserIdentity(String userId, String obsoleteIdentity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "obsoleteIdentity";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(obsoleteIdentity, "obsoleteIdentity", methodName);
        String userIdentityGUID = this.getUserIdentityGUID(userId, obsoleteIdentity, methodName);
        if (userIdentityGUID != null) {
            EntityDetail connectedProfileEntity = this.repositoryHandler.getEntityForRelationshipType(userId, userIdentityGUID, "UserIdentity", "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", methodName);
            if (connectedProfileEntity != null) {
                this.removeIdentityFromProfile(userId, connectedProfileEntity.getGUID(), obsoleteIdentity, methodName);
            }
            this.repositoryHandler.removeEntity(userId, userIdentityGUID, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", "obsoleteIdentity", obsoleteIdentity, methodName);
        }
    }

    List<UserIdentity> getAssociatedUserIds(String userId, String profileGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "profileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", methodName);
        List userIdentityRelationships = this.repositoryHandler.getRelationshipsByType(userId, profileGUID, "Person", "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", methodName);
        if (userIdentityRelationships != null) {
            ArrayList<UserIdentity> userIdentities = new ArrayList<UserIdentity>();
            for (Relationship relationship : userIdentityRelationships) {
                EntityProxy entityProxy;
                if (relationship == null || (entityProxy = relationship.getEntityTwoProxy()) == null) continue;
                String entityProxyName = "relationship.end2.entityProxy";
                EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "relationship.end2.entityProxy", "Person", methodName);
                UserIdentityConverter converter = new UserIdentityConverter(entity, this.repositoryHelper, this.serviceName);
                UserIdentity bean = converter.getBean();
                if (bean == null) continue;
                userIdentities.add(bean);
            }
            if (userIdentities.isEmpty()) {
                CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.NO_IDENTITY_FOR_PROFILE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{profileGUID});
                throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            return userIdentities;
        }
        return null;
    }
}

